/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.jolokia;

import io.fabric8.forge.camel.commands.jolokia.AbstractJolokiaCommand;
import io.fabric8.forge.camel.commands.jolokia.ConnectCommand;
import javax.inject.Inject;
import org.apache.camel.commands.CamelController;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CatalogComponentListCommand
extends AbstractJolokiaCommand {
    @Inject
    @WithAttributes(label="label", required=false, description="To filter components by their label(s), such as database")
    private UIInput<String> label;
    @Inject
    @WithAttributes(label="verbose", required=false, defaultValue="false", description="Verbose output")
    private UIInput<String> verbose;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("camel-catalog-component-list").category(Categories.create((String[])new String[]{CATEGORY_CATALOG})).description("Lists all Camel components from the Camel catalog");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.label).add(this.verbose);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String url = this.getJolokiaUrl();
        if (url == null) {
            return Results.fail((String)"Not connected to remote jolokia agent. Use camel-connect command first");
        }
        boolean val = "true".equals(this.verbose.getValue());
        org.apache.camel.commands.CatalogComponentListCommand command = new org.apache.camel.commands.CatalogComponentListCommand(val, (String)this.label.getValue());
        command.execute((CamelController)this.getController(), this.getOutput(context), this.getError(context));
        return Results.success();
    }
}

