/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.VersionHelper;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.maven.plugins.Execution;
import org.jboss.forge.addon.maven.plugins.ExecutionBuilder;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;

public class JubeSetupHelper {
    public static void setupJube(DependencyInstaller dependencyInstaller, Project project, String fromImage) {
        MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        MavenPluginBuilder plugin = MavenPluginBuilder.create().setCoordinate(JubeSetupHelper.createCoordinate("io.fabric8.jube", "jube-maven-plugin", VersionHelper.jubeVersion(), null, null));
        plugin.addExecution((Execution)ExecutionBuilder.create().addGoal("build").setPhase("package"));
        pluginFacet.addPlugin((MavenPlugin)plugin);
        String jubeImage = JubeSetupHelper.asJubeImage(fromImage);
        DependencyBuilder bom = DependencyBuilder.create().setCoordinate(JubeSetupHelper.createCoordinate("io.fabric8.jube.images.fabric8", jubeImage, VersionHelper.jubeVersion(), "image", "zip"));
        dependencyInstaller.installManaged(project, (Dependency)bom);
    }

    private static Coordinate createCoordinate(String groupId, String artifactId, String version, String classifier, String type) {
        CoordinateBuilder builder = CoordinateBuilder.create().setGroupId(groupId).setArtifactId(artifactId);
        if (version != null) {
            builder = builder.setVersion(version);
        }
        if (classifier != null) {
            builder = builder.setClassifier(classifier);
        }
        if (type != null) {
            builder = builder.setPackaging(type);
        }
        return builder;
    }

    private static String asJubeImage(String fromImage) {
        int idx = fromImage.indexOf(47);
        if (idx > 0) {
            return fromImage.substring(idx + 1);
        }
        return fromImage;
    }
}

