/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractDockerProjectCommand;
import io.fabric8.forge.camel.commands.project.VersionHelper;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.maven.plugins.Execution;
import org.jboss.forge.addon.maven.plugins.ExecutionBuilder;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class FabricStepCommand
extends AbstractDockerProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="container", required=false, description="Container label to use for the app")
    private UIInput<String> container;
    @Inject
    @WithAttributes(label="group", required=false, description="Group label to use for the app")
    private UIInput<String> group;
    @Inject
    @WithAttributes(label="icon", required=false, description="Icon to use for the app")
    private UISelectOne<String> icon;
    @Inject
    private DependencyInstaller dependencyInstaller;

    public boolean isEnabled(UIContext context) {
        return false;
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public void initializeUI(final UIBuilder builder) throws Exception {
        this.container.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String from = (String)builder.getUIContext().getAttributeMap().get("docker.from");
                if (from != null) {
                    return FabricStepCommand.asContainer(from);
                }
                return null;
            }
        });
        this.icon.setValueChoices((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                LinkedHashSet<String> choices = new LinkedHashSet<String>();
                choices.add("activemq");
                choices.add("camel");
                choices.add("java");
                choices.add("jetty");
                choices.add("karaf");
                choices.add("mule");
                choices.add("tomcat");
                choices.add("tomee");
                choices.add("weld");
                choices.add("wildfly");
                return choices.iterator();
            }
        });
        this.icon.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (FabricStepCommand.this.container.getValue() != null) {
                    for (String choice : FabricStepCommand.this.icon.getValueChoices()) {
                        if (!choice.equals(FabricStepCommand.this.container.getValue())) continue;
                        return choice;
                    }
                }
                return null;
            }
        });
        this.group.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return null;
            }
        });
        builder.add(this.container).add(this.group).add(this.icon);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        DependencyBuilder bom = DependencyBuilder.create().setCoordinate(this.createCoordinate("io.fabric8", "fabric8-project", VersionHelper.fabric8Version(), "pom")).setScopeType("import");
        this.dependencyInstaller.installManaged(project, (Dependency)bom);
        MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        MavenPluginBuilder plugin = MavenPluginBuilder.create().setCoordinate(this.createCoordinate("io.fabric8", "fabric8-maven-plugin", VersionHelper.fabric8Version())).addExecution((Execution)ExecutionBuilder.create().setId("json").addGoal("json"));
        pluginFacet.addPlugin((MavenPlugin)plugin);
        MavenFacet maven = (MavenFacet)project.getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        Properties properties = pom.getProperties();
        boolean updated = false;
        if (this.container.getValue() != null) {
            properties.put("fabric8.label.container", this.container.getValue());
            updated = true;
        }
        if (this.icon.getValue() != null) {
            properties.put("fabric8.iconRef", "icons/" + (String)this.icon.getValue());
            updated = true;
        }
        if (this.group.getValue() != null) {
            properties.put("fabric8.label.group", this.group.getValue());
            updated = true;
        }
        if (updated) {
            maven.setModel(pom);
        }
        return Results.success((String)"Adding Fabric");
    }

    private static String asContainer(String fromImage) {
        int idx = fromImage.indexOf(47);
        if (idx > 0) {
            fromImage = fromImage.substring(idx + 1);
        }
        if ((idx = fromImage.indexOf(45)) > 0) {
            fromImage = fromImage.substring(0, idx);
        }
        return fromImage;
    }
}

