/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.jolokia.ConnectCommand;
import io.fabric8.forge.camel.commands.project.AbstractFabricProjectCommand;
import io.fabric8.forge.camel.commands.project.DockerStepCommand;
import io.fabric8.forge.camel.commands.project.JubeStepCommand;
import java.util.Arrays;
import java.util.Locale;
import javax.inject.Inject;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

@FacetConstraint(value={MavenFacet.class, MavenPluginFacet.class})
public class FabricSetupCommand
extends AbstractFabricProjectCommand
implements UIWizard {
    private String[] platforms = new String[]{"Docker", "Jube", "Both"};
    @Inject
    @WithAttributes(label="platform", required=true, description="The runtime platform")
    private UISelectOne<String> platform;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("Fabric: Setup").category(Categories.create((String[])new String[]{CATEGORY})).description("Setup Fabric8 in your project");
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        context.getUIContext().getAttributeMap().put("platform", this.platform.getValue());
        if ("Both".equals(this.platform.getValue())) {
            return Results.navigateTo(DockerStepCommand.class);
        }
        if ("Docker".equals(this.platform.getValue())) {
            return Results.navigateTo(DockerStepCommand.class);
        }
        return Results.navigateTo(JubeStepCommand.class);
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.platform);
        this.platform.setValueChoices(Arrays.asList(this.platforms));
        if (FabricSetupCommand.isPlatform("windows")) {
            this.platform.setDefaultValue((Object)"Jube");
        } else {
            this.platform.setDefaultValue((Object)"Docker");
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }

    public static boolean isPlatform(String platform) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.contains(platform.toLowerCase(Locale.US));
    }
}

