/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelCommands;
import io.fabric8.forge.camel.commands.project.CamelComponentDetails;
import io.fabric8.forge.camel.commands.project.CamelProjectHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Strings;

public class ConfigureComponentPropertiesStep
extends AbstractCamelProjectCommand
implements UIWizardStep {
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private DependencyResolver dependencyResolver;
    private List<UIInput> inputs = new ArrayList<UIInput>();

    public void initializeUI(UIBuilder builder) throws Exception {
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        Map attributeMap = builder.getUIContext().getAttributeMap();
        String camelComponentName = ConfigureComponentPropertiesStep.mandatoryAttributeValue(attributeMap, "componentName");
        String json = catalog.componentJSonSchema(camelComponentName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"componentProperties", (String)json, (boolean)true);
        if (data != null) {
            HashSet<String> namesAdded = new HashSet<String>();
            for (Map propertyMap : data) {
                UIInput input;
                Class<?> inputClazz;
                String name = (String)propertyMap.get("name");
                String kind = (String)propertyMap.get("kind");
                String type = (String)propertyMap.get("type");
                String javaType = (String)propertyMap.get("javaType");
                String deprecated = (String)propertyMap.get("deprecated");
                String required = (String)propertyMap.get("required");
                if (Strings.isNullOrEmpty((String)name) || (inputClazz = CamelCommands.loadValidInputTypes(javaType, type)) == null || !namesAdded.add(name) || (input = this.componentFactory.createInput(name, inputClazz)) == null) continue;
                if (Objects.equals("true", required)) {
                    input.setRequired(true);
                }
                System.out.println("Adding input for name: " + name);
                builder.add((InputComponent)input);
                this.inputs.add(input);
            }
        }
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        try {
            String camelComponentName = ConfigureComponentPropertiesStep.mandatoryAttributeValue(attributeMap, "componentName");
            String componentInstanceName = ConfigureComponentPropertiesStep.mandatoryAttributeValue(attributeMap, "instanceName");
            String generatePackageName = ConfigureComponentPropertiesStep.mandatoryAttributeValue(attributeMap, "targetPackage");
            String generateClassName = ConfigureComponentPropertiesStep.mandatoryAttributeValue(attributeMap, "className");
            String kind = ConfigureComponentPropertiesStep.mandatoryAttributeValue(attributeMap, "kind");
            Project project = this.getSelectedProject((UIContextProvider)context);
            JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
            Dependency core = CamelProjectHelper.findCamelCoreDependency(project);
            if (core == null) {
                return Results.fail((String)"The project does not include camel-core");
            }
            CamelComponentDetails details = new CamelComponentDetails();
            Result result = CamelCommands.loadCamelComponentDetails(camelComponentName, details);
            if (result != null) {
                return result;
            }
            result = CamelCommands.ensureCamelArtifactIdAdded(project, details, this.dependencyInstaller);
            if (result != null) {
                return result;
            }
            String fqn = generatePackageName != null ? generatePackageName + "." + generateClassName : generateClassName;
            JavaResource existing = facet.getJavaResource(fqn);
            if (existing != null && existing.exists()) {
                return Results.fail((String)("A class with name " + fqn + " already exists"));
            }
            JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
            javaClass.setName(generateClassName);
            if (generatePackageName != null) {
                javaClass.setPackage(generatePackageName);
            }
            StringBuilder buffer = new StringBuilder();
            for (UIInput input : this.inputs) {
                String valueExpression = null;
                Object value = input.getValue();
                if (value != null) {
                    String text;
                    if (value instanceof String && !Strings.isBlank((String)(text = value.toString()))) {
                        valueExpression = "\"" + text + "\"";
                    }
                    if (value instanceof Number) {
                        valueExpression = value.toString();
                    }
                }
                if (valueExpression == null) continue;
                buffer.append("\n");
                buffer.append("component.set");
                buffer.append(Strings.capitalize((String)input.getName()));
                buffer.append("(");
                buffer.append(valueExpression);
                buffer.append(");");
            }
            String configurationCode = buffer.toString();
            if (kind.equals("cdi")) {
                CamelCommands.createCdiComponentProducerClass(javaClass, details, camelComponentName, componentInstanceName, configurationCode);
            } else {
                CamelCommands.createSpringComponentFactoryClass(javaClass, details, camelComponentName, componentInstanceName, configurationCode);
            }
            facet.saveJavaSource((JavaSource)javaClass);
            return Results.success((String)("Added class " + generateClassName + " to the project"));
        }
        catch (IllegalArgumentException e) {
            return Results.fail((String)e.getMessage());
        }
    }

    public static String mandatoryAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        throw new IllegalArgumentException("The attribute value '" + name + "' did not get passed on from the previous wizard page");
    }
}

