/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import org.jboss.forge.addon.parser.java.ui.validators.AbstractJLSUIValidator;
import org.jboss.forge.addon.parser.java.utils.ResultType;
import org.jboss.forge.addon.parser.java.utils.ValidationResult;

public class ClassNameValidator
extends AbstractJLSUIValidator {
    private boolean allowPackageName;

    public ClassNameValidator(boolean allowPackageName) {
        this.allowPackageName = allowPackageName;
    }

    protected ValidationResult validate(String s) {
        char ch;
        if (s == null) {
            return new ValidationResult(ResultType.INFO);
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            ch = chars[i];
            if (this.allowPackageName && ch == '.' || Character.isJavaIdentifierPart(ch)) continue;
            return new ValidationResult(ResultType.ERROR, "The class name [" + s + "] is invalid at position " + (i + 1));
        }
        int idx = 0;
        if (this.allowPackageName && s.lastIndexOf(46) != -1) {
            idx = s.lastIndexOf(46) + 1;
        }
        if (!Character.isUpperCase(ch = s.charAt(idx))) {
            return new ValidationResult(ResultType.ERROR, "The class name [" + s + "] must start with an upper case alphabetic character at index " + idx);
        }
        return new ValidationResult(ResultType.INFO);
    }
}

