/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.jolokia;

import io.fabric8.forge.camel.commands.jolokia.AbstractJolokiaCommand;
import io.fabric8.forge.camel.commands.jolokia.CamelContextCompleter;
import io.fabric8.forge.camel.commands.jolokia.ConnectCommand;
import javax.inject.Inject;
import org.apache.camel.commands.CamelController;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class EndpointExplainCommand
extends AbstractJolokiaCommand {
    @Inject
    @WithAttributes(label="name", required=true, description="The name of the Camel context")
    private UIInput<String> name;
    @Inject
    @WithAttributes(label="filter", required=false, description="To filter endpoints by pattern")
    private UIInput<String> filter;
    @Inject
    @WithAttributes(label="verbose", required=false, defaultValue="false", description="Verbose output")
    private UIInput<String> verbose;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("camel-endpoint-explain").category(Categories.create((String[])new String[]{CATEGORY})).description("Explain all endpoints available in a CamelContext");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        this.name.setCompleter((UICompleter)new CamelContextCompleter(this.getController()));
        builder.add(this.name).add(this.filter).add(this.verbose);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String url = this.getJolokiaUrl();
        if (url == null) {
            return Results.fail((String)"Not connected to remote jolokia agent. Use camel-connect command first");
        }
        boolean val = "true".equals(this.verbose.getValue());
        org.apache.camel.commands.EndpointExplainCommand command = new org.apache.camel.commands.EndpointExplainCommand((String)this.name.getValue(), val, (String)this.filter.getValue());
        command.execute((CamelController)this.getController(), this.getOutput(context), this.getError(context));
        return Results.success();
    }
}

