/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.jolokia.ConnectCommand;
import io.fabric8.forge.camel.commands.project.AbstractDockerProjectCommand;
import io.fabric8.forge.camel.commands.project.DockerSetupHelper;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={MavenFacet.class, MavenPluginFacet.class})
public class DockerSetupCommand
extends AbstractDockerProjectCommand {
    private String[] jarImages = new String[]{"fabric8/java"};
    private String[] bundleImages = new String[]{"fabric8/karaf-2.4"};
    private String[] warImages = new String[]{"fabric8/tomcat-8.0", "jboss/wildfly"};
    @Inject
    @WithAttributes(label="from", required=true, description="The docker image to use as base line")
    private UISelectOne<String> from;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("Docker: Setup").category(Categories.create((String[])new String[]{CATEGORY})).description("Setup Docker in your project");
    }

    public void initializeUI(final UIBuilder builder) throws Exception {
        builder.add(this.from);
        this.from.setValueChoices((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                LinkedHashSet<String> choices = new LinkedHashSet<String>();
                choices.add(DockerSetupCommand.this.jarImages[0]);
                choices.add(DockerSetupCommand.this.bundleImages[0]);
                choices.add(DockerSetupCommand.this.warImages[0]);
                choices.add(DockerSetupCommand.this.warImages[1]);
                return choices.iterator();
            }
        });
        this.from.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return DockerSetupHelper.defaultDockerImage(DockerSetupCommand.this.getSelectedProject((UIContextProvider)builder));
            }
        });
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        String fromImage = this.from != null ? (String)this.from.getValue() : "fabric8/java";
        DockerSetupHelper.setupDocker(project, fromImage);
        return Results.success((String)"Added Docker to the project");
    }

    protected String getProjectPackaging(Project project) {
        if (project != null) {
            MavenFacet maven = (MavenFacet)project.getFacet(MavenFacet.class);
            return maven.getModel().getPackaging();
        }
        return null;
    }
}

