/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelCatalogHelper;
import java.io.PrintStream;
import java.util.Set;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelInfoCommand
extends AbstractCamelProjectCommand {
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelInfoCommand.class).name("Camel: Info").category(Categories.create((String[])new String[]{CATEGORY})).description("Displays what the current project includes of Camel components");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
    }

    @Override
    public boolean isEnabled(UIContext context) {
        return super.isEnabled(context) && !context.getProvider().isGUI();
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        PrintStream out = this.getOutput(context);
        out.println("");
        out.println("Camel Project Information");
        out.println("=========================");
        Set<Dependency> artifacts = this.findCamelArtifacts(project);
        for (Dependency d : artifacts) {
            Set<String> languages;
            Set<String> dataFormats;
            out.println("      artifact: " + d.getCoordinate().getArtifactId());
            Set<String> components = CamelCatalogHelper.componentsFromArtifact(d.getCoordinate().getArtifactId());
            if (!components.isEmpty()) {
                out.print("     component: ");
                for (String c : components) {
                    out.print(c);
                    out.print(" ");
                }
                out.println("");
            }
            if (!(dataFormats = CamelCatalogHelper.dataFormatsFromArtifact(d.getCoordinate().getArtifactId())).isEmpty()) {
                out.print("    dataformat: ");
                for (String df : dataFormats) {
                    out.print(df);
                    out.print(" ");
                }
                out.println("");
            }
            if (!(languages = CamelCatalogHelper.languagesFromArtifact(d.getCoordinate().getArtifactId())).isEmpty()) {
                out.print("      language: ");
                for (String l : languages) {
                    out.print(l);
                    out.print(" ");
                }
                out.println("");
            }
            out.println("");
        }
        return Results.success();
    }
}

