/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.CamelComponentDetails;
import io.fabric8.forge.camel.commands.project.CamelComponentsCompleter;
import io.fabric8.forge.camel.commands.project.CamelComponentsLabelCompleter;
import io.fabric8.forge.camel.commands.project.CamelProjectHelper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.util.Strings;

public final class CamelCommands {
    private static final boolean validateClassPathForProjectValidation = false;

    public static Iterable<String> createComponentNameValues(Project project) {
        return new CamelComponentsLabelCompleter(project).getValueChoices();
    }

    public static Callable<Iterable<String>> createComponentNameValues(final Project project, final UISelectOne<String> componentCategoryFilter, final boolean excludeComponentsOnClasspath) {
        return new Callable<Iterable<String>>(){

            @Override
            public Iterable<String> call() throws Exception {
                String label = (String)componentCategoryFilter.getValue();
                return new CamelComponentsCompleter(project, null, excludeComponentsOnClasspath).getValueChoices(label);
            }
        };
    }

    public static Result loadCamelComponentDetails(String camelComponentName, CamelComponentDetails details) {
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String json = catalog.componentJSonSchema(camelComponentName);
        if (json == null) {
            return Results.fail((String)("Could not find catalog entry for component name: " + camelComponentName));
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            String artifactId;
            String javaType = (String)row.get("javaType");
            if (!Strings.isNullOrEmpty((String)javaType)) {
                details.setComponentClassQName(javaType);
            }
            if (Strings.isNullOrEmpty((String)(artifactId = (String)row.get("artifactId")))) continue;
            details.setArtifactId(artifactId);
        }
        if (Strings.isNullOrEmpty((String)details.getComponentClassQName())) {
            return Results.fail((String)("Could not find fully qualified class name in catalog for component name: " + camelComponentName));
        }
        return null;
    }

    public static Result ensureCamelArtifactIdAdded(Project project, CamelComponentDetails details, DependencyInstaller dependencyInstaller) {
        String artifactId = details.getArtifactId();
        Dependency core = CamelProjectHelper.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        DependencyBuilder component = DependencyBuilder.create().setGroupId("org.apache.camel").setArtifactId(artifactId).setVersion(core.getCoordinate().getVersion());
        dependencyInstaller.install(project, (Dependency)component);
        return null;
    }

    public static boolean isCdiProject(Project project) {
        return CamelProjectHelper.findCamelCDIDependency(project) != null;
    }

    public static boolean isSpringProject(Project project) {
        return CamelProjectHelper.findCamelSpringDependency(project) != null;
    }

    public static boolean isBlueprintProject(Project project) {
        return CamelProjectHelper.findCamelBlueprintDependency(project) != null;
    }

    protected static void createCdiComponentProducerClass(JavaClassSource javaClass, CamelComponentDetails details, String camelComponentName, String componentInstanceName, String configurationCode) {
        javaClass.addImport("javax.enterprise.inject.Produces");
        javaClass.addImport("javax.inject.Singleton");
        javaClass.addImport("javax.inject.Named");
        javaClass.addImport(details.getComponentClassQName());
        String componentClassName = details.getComponentClassName();
        String methodName = "create" + Strings.capitalize((String)componentInstanceName) + "Component";
        String body = componentClassName + " component = new " + componentClassName + "();" + configurationCode + "\nreturn component;";
        MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setPublic()).setReturnType(componentClassName).setName(methodName)).setBody(body).addThrows(Exception.class);
        method.addAnnotation("Named").setStringValue(camelComponentName);
        method.addAnnotation("Produces");
        method.addAnnotation("Singleton");
    }

    protected static void createSpringComponentFactoryClass(JavaClassSource javaClass, CamelComponentDetails details, String camelComponentName, String componentInstanceName, String configurationCode) {
        javaClass.addAnnotation("Component");
        javaClass.addImport("org.springframework.beans.factory.config.BeanDefinition");
        javaClass.addImport("org.springframework.beans.factory.annotation.Qualifier");
        javaClass.addImport("org.springframework.context.annotation.Bean");
        javaClass.addImport("org.springframework.context.annotation.Scope");
        javaClass.addImport("org.springframework.stereotype.Component");
        javaClass.addImport(details.getComponentClassQName());
        String componentClassName = details.getComponentClassName();
        String methodName = "create" + Strings.capitalize((String)componentInstanceName) + "Component";
        String body = componentClassName + " component = new " + componentClassName + "();" + configurationCode + "\nreturn component;";
        MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setPublic()).setReturnType(componentClassName).setName(methodName)).setBody(body).addThrows(Exception.class);
        method.addAnnotation("Qualifier").setStringValue(camelComponentName);
        method.addAnnotation("Bean");
        method.addAnnotation("Scope").setLiteralValue("BeanDefinition.SCOPE_SINGLETON");
    }

    protected static Class<?> loadValidInputTypes(String javaType, String type) {
        try {
            Class<?> clazz = Class.forName(javaType);
            if (clazz.equals(String.class) || clazz.equals(Date.class) || clazz.isPrimitive() || Number.class.isAssignableFrom(clazz)) {
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

