/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactory;

public class CamelArchetypeCatalogFactory
implements ArchetypeCatalogFactory {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String NAME = "camel";
    private ArchetypeCatalog cachedArchetypes;

    public String getName() {
        return NAME;
    }

    public ArchetypeCatalog getArchetypeCatalog() {
        String xml;
        if (this.cachedArchetypes == null && (xml = new DefaultCamelCatalog().archetypeCatalogAsXml()) != null) {
            try {
                this.cachedArchetypes = new ArchetypeCatalogXpp3Reader().read((Reader)new StringReader(xml));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while retrieving archetypes", e);
            }
        }
        return this.cachedArchetypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CamelArchetypeCatalogFactory that = (CamelArchetypeCatalogFactory)o;
        return NAME.equals(NAME);
    }

    public int hashCode() {
        return NAME.hashCode();
    }
}

