/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.CamelCommands;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelAddComponentCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="filter", required=false, description="To filter components")
    private UISelectOne<String> filter;
    @Inject
    @WithAttributes(label="name", required=true, description="Name of component to add")
    private UISelectOne<String> name;
    @Inject
    private DependencyInstaller dependencyInstaller;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddComponentCommand.class).name("Camel: New Component").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel component to your project");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            Project project = this.getSelectedProjectOrNull(context);
            return project != null && !CamelCommands.isCdiProject(project) && !CamelCommands.isSpringProject(project);
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)builder);
        this.filter.setValueChoices(CamelCommands.createComponentNameValues(project));
        this.filter.setDefaultValue((Object)"<all>");
        this.name.setValueChoices(CamelCommands.createComponentNameValues(project, this.filter, true));
        builder.add(this.filter);
        builder.add(this.name);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        String artifactId = CamelCatalogHelper.findComponentArchetype((String)this.name.getValue());
        if (artifactId == null) {
            return Results.fail((String)("Camel component " + (String)this.name.getValue() + " is unknown."));
        }
        DependencyBuilder component = DependencyBuilder.create().setGroupId("org.apache.camel").setArtifactId(artifactId).setVersion(core.getCoordinate().getVersion());
        this.dependencyInstaller.install(project, (Dependency)component);
        return Results.success((String)("Added Camel component " + (String)this.name.getValue() + " (" + artifactId + ") to the project"));
    }
}

