/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.CamelProjectHelper;
import java.io.PrintStream;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;

public abstract class AbstractCamelProjectCommand
extends AbstractProjectCommand {
    public static String CATEGORY = "Camel";
    @Inject
    protected ProjectFactory projectFactory;

    protected boolean isProjectRequired() {
        return true;
    }

    public boolean isEnabled(UIContext context) {
        if (this.requiresCamelSetup()) {
            Project project = this.getSelectedProjectOrNull(context);
            return project != null && super.isEnabled(context) && this.findCamelCoreDependency(project) != null;
        }
        return super.isEnabled(context);
    }

    protected Project getSelectedProjectOrNull(UIContext context) {
        return Projects.getSelectedProject((ProjectFactory)this.getProjectFactory(), (UIContext)context);
    }

    protected boolean requiresCamelSetup() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    protected PrintStream getOutput(UIExecutionContext context) {
        return context.getUIContext().getProvider().getOutput().out();
    }

    protected Dependency findCamelCoreDependency(Project project) {
        return CamelProjectHelper.findCamelCoreDependency(project);
    }

    protected Set<Dependency> findCamelArtifacts(Project project) {
        return CamelProjectHelper.findCamelArtifacts(project);
    }

    protected Coordinate createCoordinate(String groupId, String artifactId, String version) {
        CoordinateBuilder builder = CoordinateBuilder.create().setGroupId(groupId).setArtifactId(artifactId);
        if (version != null) {
            builder = builder.setVersion(version);
        }
        return builder;
    }

    protected Coordinate createCamelCoordinate(String artifactId, String version) {
        return this.createCoordinate("org.apache.camel", artifactId, version);
    }
}

