/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.utils.Block;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asserts {
    private static final transient Logger LOG = LoggerFactory.getLogger(Asserts.class);

    public static AssertionError assertAssertionError(Block block) throws Exception {
        AssertionError answer = null;
        try {
            block.invoke();
        }
        catch (AssertionError e) {
            answer = e;
            System.out.println("Caught expected assertion failure: " + e);
        }
        catch (Exception e) {
            throw e;
        }
        if (answer == null) {
            throw new AssertionError((Object)("Expected an assertion error from block: " + block));
        }
        LOG.info("Caught expected assertion failure: " + answer);
        return answer;
    }

    public static Exception assertException(Block block) throws Exception {
        Exception answer = null;
        try {
            block.invoke();
        }
        catch (Exception e) {
            answer = e;
            System.out.println("Caught expected assertion failure: " + e);
        }
        if (answer == null) {
            throw new AssertionError((Object)("Expected an Exception from block: " + block));
        }
        LOG.info("Caught expected assertion failure: " + answer);
        return answer;
    }

    public static void assertWaitFor(long timeoutMs, Block block) throws Exception {
        long end = System.currentTimeMillis() + timeoutMs;
        AssertionError failure = null;
        while (true) {
            if (System.currentTimeMillis() > end) {
                if (failure != null) {
                    throw failure;
                }
                return;
            }
            try {
                block.invoke();
                return;
            }
            catch (AssertionError e) {
                failure = e;
            }
            catch (Throwable e) {
                failure = new AssertionError((Object)e);
            }
            LOG.debug("Ignoring exception in assertWaitFor() loop: " + failure, (Throwable)((Object)failure));
            if (Asserts.isVerboseWaitMessage()) {
                ((Throwable)((Object)failure)).printStackTrace();
            }
            Thread.sleep(1000L);
        }
    }

    public static void assertForPeriod(long timeoutMs, Block block) throws Exception {
        long end = System.currentTimeMillis() + timeoutMs;
        while (System.currentTimeMillis() <= end) {
            try {
                block.invoke();
            }
            catch (AssertionError e) {
                if (Asserts.isVerboseWaitMessage()) {
                    ((Throwable)((Object)e)).printStackTrace();
                }
                throw e;
            }
            catch (Throwable e) {
                if (Asserts.isVerboseWaitMessage()) {
                    e.printStackTrace();
                }
                throw new AssertionError((Object)e);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected static boolean isVerboseWaitMessage() {
        String value = System.getenv("FABRIC8_VERBOSE_ASSERT");
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void assertWaitFor(Block block) throws Exception {
        Asserts.assertWaitFor(30000L, block);
    }
}

