/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.utils.Objects;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomHelper {
    private static TransformerFactory transformerFactory;
    private static Transformer transformer;

    public static Element addChildElement(Node parent, String elementName) {
        Document ownerDocument = parent.getOwnerDocument();
        Objects.notNull(ownerDocument, "nodes ownerDocument " + parent);
        Element element = ownerDocument.createElement(elementName);
        parent.appendChild(element);
        return element;
    }

    public static Element addChildElement(Node parent, String elementName, String textContent) {
        Element element = DomHelper.addChildElement(parent, elementName);
        element.setTextContent(textContent);
        return element;
    }

    public static void save(Document document, File file) throws FileNotFoundException, TransformerException {
        Transformer transformer = DomHelper.getTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(new FileOutputStream(file)));
    }

    public static String toXml(Document document) throws TransformerException {
        Transformer transformer = DomHelper.getTransformer();
        StringWriter buffer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(buffer));
        return buffer.toString();
    }

    public static Transformer getTransformer() throws TransformerConfigurationException {
        if (transformer == null) {
            transformer = DomHelper.getTransformerFactory().newTransformer();
        }
        return transformer;
    }

    public static void setTransformer(Transformer transformer) {
        DomHelper.transformer = transformer;
    }

    public static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public static void setTransformerFactory(TransformerFactory transformerFactory) {
        DomHelper.transformerFactory = transformerFactory;
    }

    public static void detach(Node node) {
        Node parentNode;
        if (node != null && (parentNode = node.getParentNode()) != null) {
            parentNode.removeChild(node);
        }
    }

    public static void replaceWith(Node oldNode, Node newNode) {
        Node parentNode = oldNode.getParentNode();
        if (parentNode != null) {
            parentNode.replaceChild(newNode, oldNode);
        }
    }

    public static void removePreviousSiblingText(Element element) {
        Node sibling;
        while ((sibling = element.getPreviousSibling()) instanceof Text) {
            DomHelper.detach(sibling);
        }
    }

    public static void removeNextSiblingText(Element element) {
        Node sibling;
        while ((sibling = element.getNextSibling()) instanceof Text) {
            DomHelper.detach(sibling);
        }
    }

    public static Element firstChild(Element element, String name) {
        NodeList nodes = element.getChildNodes();
        if (nodes != null) {
            int size = nodes.getLength();
            for (int i = 0; i < size; ++i) {
                Element childElement;
                Node item = nodes.item(i);
                if (!(item instanceof Element) || !name.equals((childElement = (Element)item).getTagName())) continue;
                return childElement;
            }
        }
        return null;
    }

    public static Element firstChildElement(Node node) {
        if (node != null) {
            NodeList nodes = node.getChildNodes();
            int size = nodes.getLength();
            for (int i = 0; i < size; ++i) {
                Node item = nodes.item(i);
                if (!(item instanceof Element)) continue;
                return (Element)item;
            }
        }
        return null;
    }
}

