/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.utils.Arrays;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Maps {
    public static boolean isNullOrEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> void putAll(Map<K, V> output, Map<K, V> input, K ... keys) {
        for (K key : keys) {
            V value = input.get(key);
            if (value == null) continue;
            output.put(key, value);
        }
    }

    public static boolean booleanValue(Map<String, ?> map, String key) {
        return Maps.booleanValue(map, key, false);
    }

    public static boolean booleanValue(Map<String, ?> map, String key, boolean defaultValue) {
        Object obj = map.get(key);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Boolean) {
            Boolean value = (Boolean)obj;
            return value;
        }
        String text = obj.toString();
        return Boolean.parseBoolean(text);
    }

    public static Integer integerValue(Map<String, ?> map, String key) {
        return Maps.integerValue(map, key, null);
    }

    public static Integer integerValue(Map<String, ?> map, String key, Integer defaultValue) {
        String text;
        Object obj = map.get(key);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return number.intValue();
        }
        if (obj != null && Strings.isNotBlank(text = obj.toString())) {
            return Integer.parseInt(text);
        }
        return defaultValue;
    }

    public static Long longValue(Map<String, ?> map, String key) {
        return Maps.longValue(map, key, null);
    }

    public static Long longValue(Map<String, ?> map, String key, Long defaultValue) {
        String text;
        Object obj = map.get(key);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return number.longValue();
        }
        if (obj != null && Strings.isNotBlank(text = obj.toString())) {
            return Long.parseLong(text);
        }
        return defaultValue;
    }

    protected static Object valueOrNull(Map<String, Object> map, String key) {
        return Maps.value(map, key, null);
    }

    public static Object value(Map<String, Object> map, String key, Object defaultValue) {
        Object obj = map.get(key);
        if (obj == null) {
            return defaultValue;
        }
        return obj;
    }

    public static String stringValue(Map map, String key) {
        return Maps.stringValue(map, key, null);
    }

    public static String stringValue(Map map, String key, String defaultValue) {
        Object obj = map.get(key);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return String.valueOf(obj);
    }

    public static void setValue(Map map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        } else {
            map.remove(key);
        }
    }

    public static String[] stringValues(Map map, String key) {
        Object obj = map.get(key);
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        if (obj instanceof String) {
            String text = (String)obj;
            return text.split(",");
        }
        return null;
    }

    public static void setStringValues(Map map, String key, String[] values) {
        if (values != null) {
            String text = Arrays.join(",", values);
            map.put(key, text);
        } else {
            map.remove(key);
        }
    }

    public static List listValue(Map<String, Object> map, String key) {
        Object value = null;
        if (map != null) {
            value = map.get(key);
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Object[]) {
            return java.util.Arrays.asList((Object[])value);
        }
        if (value != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            return list;
        }
        return null;
    }

    public static String valueAsString(Map<String, Object> map, String key) {
        Object value;
        if (map != null && (value = Maps.valueOrNull(map, key)) != null) {
            return value.toString();
        }
        return null;
    }

    public static String nestedValueAsString(Map<String, Object> map, String ... names) {
        int lastIdx = names.length - 1;
        for (int i = 0; i < lastIdx; ++i) {
            if (map == null) {
                return null;
            }
            map = (Map)Maps.value(map, names[i], null);
        }
        return Maps.valueAsString(map, names[lastIdx]);
    }

    public static Map<String, String> parseMap(String text) {
        String[] entries;
        HashMap<String, String> answer = new HashMap<String, String>();
        if (Strings.isNotBlank(text) && (entries = text.split(",")) != null) {
            for (String entry : entries) {
                String[] values = entry.split("=", 2);
                if (values == null || values.length != 2) continue;
                answer.put(values[0], values[1]);
            }
        }
        return answer;
    }
}

