/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.converters;

import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.spring.boot.converters.ServiceToString;
import io.fabric8.spring.boot.converters.ServiceToUrl;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.core.convert.converter.Converter;

public class KubernetesConverterServiceFactory
extends ConversionServiceFactoryBean {
    private KubernetesClient kubernetesClient;

    public KubernetesConverterServiceFactory(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
        this.setConverters(this.createConverters());
    }

    private Set<Converter> createConverters() {
        LinkedHashSet<Converter> converters = new LinkedHashSet<Converter>();
        ServiceToString serviceToString = new ServiceToString(this.kubernetesClient);
        ServiceToUrl serviceToUrl = new ServiceToUrl(serviceToString);
        converters.add(serviceToString);
        converters.add(serviceToUrl);
        return converters;
    }
}

