/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot;

import io.fabric8.annotations.Alias;
import io.fabric8.annotations.External;
import io.fabric8.annotations.Factory;
import io.fabric8.annotations.Protocol;
import io.fabric8.annotations.ServiceName;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.spring.boot.KubernetesServiceFactoryBean;
import io.fabric8.spring.boot.converters.FactoryConverter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public abstract class AbstractServiceRegistar
implements ImportBeanDefinitionRegistrar {
    private static final Reflections REFLECTIONS = new Reflections((Configuration)new ConfigurationBuilder().setUrls(((URLClassLoader)AbstractServiceRegistar.class.getClassLoader()).getURLs()).setScanners(new Scanner[]{new FieldAnnotationsScanner(), new MethodAnnotationsScanner()}));

    public abstract Service getService(String var1);

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        for (Method method : REFLECTIONS.getMethodsAnnotatedWith(Factory.class)) {
            String methodName = method.getName();
            Class sourceType = AbstractServiceRegistar.getSourceType(method);
            Class<?> targetType = method.getReturnType();
            Class<?> beanType = method.getDeclaringClass();
            BeanDefinitionHolder holder = this.createConverterBean(beanType, methodName, sourceType, targetType);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        }
        for (Field field : REFLECTIONS.getFieldsAnnotatedWith(ServiceName.class)) {
            Alias alias = field.getAnnotation(Alias.class);
            ServiceName name = field.getAnnotation(ServiceName.class);
            Protocol protocol = field.getAnnotation(Protocol.class);
            External external = field.getAnnotation(External.class);
            String serviceProtocol = protocol != null ? protocol.value() : "tcp";
            String serviceAlias = alias != null ? alias.value() : name.value();
            Boolean serviceExternal = external != null && external.value();
            Service serviceInstance = this.getService(name.value());
            serviceInstance.getAdditionalProperties().put("ALIAS", serviceAlias);
            serviceInstance.getAdditionalProperties().put("PROTOCOL", serviceProtocol);
            serviceInstance.getAdditionalProperties().put("EXTERNAL", serviceExternal);
            Class<?> targetClass = field.getType();
            BeanDefinitionHolder holder = this.createServiceDefinition(serviceInstance, serviceAlias, serviceProtocol, targetClass);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        }
    }

    private static Class getSourceType(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            for (int j = 0; j < annotations[i].length; ++j) {
                if (!ServiceName.class.equals(annotations[i][j].annotationType())) continue;
                return method.getParameterTypes()[i];
            }
        }
        throw new IllegalStateException("No source type found for @Factory:" + method.getName());
    }

    private <S, T> BeanDefinitionHolder createConverterBean(Class type, String methodName, Class<S> sourceType, Class<T> targetType) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FactoryConverter.class);
        String beanName = type.getName() + "." + methodName;
        builder.addPropertyValue("name", (Object)methodName);
        builder.addPropertyValue("type", (Object)type.getCanonicalName());
        builder.addPropertyValue("sourceType", (Object)sourceType.getCanonicalName());
        builder.addPropertyValue("targetType", (Object)targetType.getCanonicalName());
        builder.setAutowireMode(Autowire.BY_TYPE.value());
        return new BeanDefinitionHolder((BeanDefinition)builder.getBeanDefinition(), beanName);
    }

    private BeanDefinitionHolder createServiceDefinition(Service service, String alias, String protocol, Class type) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(KubernetesServiceFactoryBean.class);
        builder.addPropertyValue("name", (Object)alias);
        builder.addPropertyValue("service", (Object)service);
        builder.addPropertyValue("type", (Object)type.getCanonicalName());
        builder.setAutowireMode(Autowire.BY_TYPE.value());
        builder.getBeanDefinition().addQualifier(new AutowireCandidateQualifier(Protocol.class, (Object)protocol));
        return new BeanDefinitionHolder((BeanDefinition)builder.getBeanDefinition(), alias);
    }
}

