/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.external;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.spring.boot.AbstractServiceRegistar;
import io.fabric8.utils.Systems;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class ExternalServiceRegistrar
extends AbstractServiceRegistar
implements BeanFactoryAware {
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    public static final String DEFAULT_NAMESPACE = "default";
    private BeanFactory beanFactory;
    private KubernetesClient kubernetesClient;

    public ExternalServiceRegistrar() {
        System.out.print("");
    }

    @Override
    public Service getService(String name) {
        String serviceNamespace = Systems.getEnvVarOrSystemProperty((String)KUBERNETES_NAMESPACE, (String)DEFAULT_NAMESPACE);
        if (this.kubernetesClient == null) {
            this.kubernetesClient = (KubernetesClient)this.beanFactory.getBean(KubernetesClient.class);
        }
        return (Service)((ClientResource)((ClientNonNamespaceOperation)this.kubernetesClient.services().inNamespace(serviceNamespace)).withName(name)).get();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

