/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot;

import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.spring.boot.converters.KubernetesConverterServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ConversionServiceFactoryBean;

@Configuration
public class KubernetesClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesClientConfiguration.class);
    @Value(value="${kubernetes.master}")
    private String kubernetesMasterUrl;

    @Bean
    public KubernetesClient kubernetesClient() {
        LOGGER.debug("Trying to init {} by auto-configuration.", (Object)Kubernetes.class.getSimpleName());
        KubernetesFactory factory = new KubernetesFactory(this.kubernetesMasterUrl);
        return new KubernetesClient(factory);
    }

    @Bean
    public ConversionServiceFactoryBean conversionService() {
        return new KubernetesConverterServiceFactory(this.kubernetesClient());
    }
}

