/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.selenium.inputs;

import io.fabric8.selenium.PageSupport;
import io.fabric8.selenium.WebDriverFacade;
import io.fabric8.utils.Millis;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public class InputValue
extends PageSupport {
    private final By by;
    private final String value;

    public InputValue(WebDriverFacade facade, By by, String value) {
        super(facade);
        this.by = by;
        this.value = value;
    }

    public String toString() {
        return "InputValue{by=" + this.by + ", value='" + this.value + '\'' + '}';
    }

    public By getBy() {
        return this.by;
    }

    public String getValue() {
        return this.value;
    }

    public WebElement doInput() {
        WebElement element = this.getFacade().findOptionalElement(this.by);
        if (element != null) {
            for (int i = 0; i < 10; ++i) {
                try {
                    this.doInputOnElement(element);
                    return element;
                }
                catch (StaleElementReferenceException e) {
                    this.logWarn("Caught: " + (Object)((Object)e));
                    this.getFacade().sleep(Millis.seconds((int)5));
                    continue;
                }
            }
            this.logWarn("Failed to perform input on " + this.by + " to due repeated StaleElementReferenceException!");
        }
        return null;
    }

    protected void doInputOnElement(WebElement element) {
        element.clear();
        element.sendKeys(new CharSequence[]{this.value});
    }
}

