/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.selenium;

import com.google.common.base.Function;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.selenium.WebDriverFacade;
import io.fabric8.utils.Systems;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.safari.SafariDriver;

public class SeleniumTests {
    public static final String WAIT_AFTER_SELENIUM = "WAIT_AFTER_SELENIUM";
    public static final String FABRIC8_WEBDRIVER_NAME = "FABRIC8_WEBDRIVER_NAME";

    public static <T> T assertWebDriverForService(KubernetesClient client, String namespace, String serviceName, Function<WebDriverFacade, T> block) throws Exception {
        WebDriver driver = SeleniumTests.createWebDriver();
        return SeleniumTests.assertWebDriverForService(client, namespace, serviceName, driver, block);
    }

    public static <T> T assertWebDriverForService(KubernetesClient client, String namespace, String serviceName, WebDriver driver, Function<WebDriverFacade, T> block) throws Exception {
        try {
            WebDriverFacade facade = new WebDriverFacade(driver, client, namespace);
            facade.navigateToService(serviceName);
            Object apply = block.apply((Object)facade);
            String property = Systems.getEnvVarOrSystemProperty((String)WAIT_AFTER_SELENIUM);
            if (property != null) {
                long millis = 0L;
                try {
                    millis = Long.parseLong(property);
                }
                catch (NumberFormatException e) {
                    SeleniumTests.logWarn("Env var / system property WAIT_AFTER_SELENIUM is not a long value: " + property + ". " + e, e);
                }
                if (millis > 0L) {
                    SeleniumTests.logInfo("Sleeping for " + millis + " millis before tearning down the test case");
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            Object object = apply;
            return (T)object;
        }
        catch (Exception e) {
            SeleniumTests.logError("Failed with exception: ", e);
            throw e;
        }
        finally {
            driver.quit();
        }
    }

    public static WebDriver createWebDriver() {
        WebDriver answer = SeleniumTests.doCreateWebDriver();
        SeleniumTests.logInfo("Using WebDriver implementation: " + answer);
        return answer;
    }

    protected static WebDriver doCreateWebDriver() {
        String driverName = Systems.getEnvVarOrSystemProperty((String)FABRIC8_WEBDRIVER_NAME);
        if (driverName != null) {
            if ((driverName = driverName.toLowerCase()).equals("chrome")) {
                return new ChromeDriver();
            }
            if (driverName.equals("edge")) {
                return new EdgeDriver();
            }
            if (driverName.equals("firefox")) {
                return new FirefoxDriver();
            }
            if (driverName.equals("htmlunit")) {
                return new HtmlUnitDriver();
            }
            if (driverName.equals("internetexplorer") || driverName.equals("ie")) {
                return new InternetExplorerDriver();
            }
            if (driverName.equals("opera")) {
                return new OperaDriver();
            }
            if (driverName.equals("phantomjs")) {
                return new PhantomJSDriver();
            }
            if (driverName.equals("safari")) {
                return new SafariDriver();
            }
            if (driverName.equals("htmlunit")) {
                return new HtmlUnitDriver();
            }
        }
        return new ChromeDriver();
    }

    public static void logError(String message, Throwable e) {
        System.out.println("ERROR: " + message + e);
        e.printStackTrace();
        Throwable cause = e.getCause();
        if (cause != null && cause != e) {
            SeleniumTests.logError("Caused by: ", cause);
        }
    }

    public static void logWait(String message) {
        System.out.println("WAITING: " + message);
    }

    public static void logInput(String message) {
        System.out.println("INPUT: " + message);
    }

    public static void logClick(String message) {
        System.out.println("CLICK: " + message);
    }

    public static void logSubmit(String message) {
        System.out.println("SUBMIT: " + message);
    }

    public static void logInfo(String message) {
        System.out.println("INFO: " + message);
    }

    public static void logWarn(String message) {
        System.out.println("WARN: " + message);
    }

    public static void logWarn(String message, Throwable e) {
        System.out.println("WARN: " + message + e);
        e.printStackTrace();
        Throwable cause = e.getCause();
        if (cause != null && cause != e) {
            SeleniumTests.logWarn("Caused by: ", cause);
        }
    }
}

