/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.project.support;

import io.fabric8.repo.git.GitRepoClient;
import io.fabric8.utils.Strings;
import java.io.File;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDetails {
    private static final transient Logger LOG = LoggerFactory.getLogger(UserDetails.class);
    private final String internalAddress;
    private final String email;
    private String user;
    private String password;
    private String address;
    private String branch = "master";
    private File sshPrivateKey;
    private File sshPublicKey;

    public UserDetails(String address, String internalAddress, String user, String password, String email) {
        this.internalAddress = internalAddress;
        this.user = user;
        this.password = password;
        this.address = address;
        this.email = email;
    }

    public UserDetails createAnonymousDetails() {
        String dummyPassword = "";
        return new UserDetails(this.address, this.internalAddress, this.user, dummyPassword, this.email);
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getInternalAddress() {
        return this.internalAddress;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public GitRepoClient createRepoClient() {
        LOG.info("creating git repository client at: " + this.internalAddress);
        return new GitRepoClient(this.internalAddress, this.user, this.password);
    }

    public CredentialsProvider createCredentialsProvider() {
        return new UsernamePasswordCredentialsProvider(this.user, this.password){

            public boolean isInteractive() {
                return false;
            }

            public String toString() {
                return "UsernamePasswordCredentialsProvider{user: " + UserDetails.this.getUser() + ", password length: " + (Strings.isNullOrBlank((String)UserDetails.this.password) ? 0 : UserDetails.this.password.length()) + "}";
            }
        };
    }

    public PersonIdent createPersonIdent() {
        return new PersonIdent(this.user, this.email);
    }

    public File getSshPrivateKey() {
        return this.sshPrivateKey;
    }

    public void setSshPrivateKey(File sshPrivateKey) {
        this.sshPrivateKey = sshPrivateKey;
    }

    public File getSshPublicKey() {
        return this.sshPublicKey;
    }

    public void setSshPublicKey(File sshPublicKey) {
        this.sshPublicKey = sshPublicKey;
    }
}

