/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven;

import io.fabric8.devops.connector.WebHooks;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.AbstractNamespacedMojo;
import io.fabric8.repo.git.GitRepoClient;
import io.fabric8.repo.git.GitRepoKubernetes;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="create-gogs-webhook", requiresProject=false)
public class CreateGogsWebhook
extends AbstractNamespacedMojo {
    @Parameter(property="webhookUrl", required=true)
    private String webhookUrl;
    @Parameter(property="repo", required=true)
    private String repo;
    @Parameter(property="gogsUsername", defaultValue="${JENKINS_GOGS_USER}")
    private String gogsUsername;
    @Parameter(property="gogsPassword", defaultValue="${JENKINS_GOGS_PASSWORD}")
    private String gogsPassword;
    @Parameter(property="secret", defaultValue="secret101")
    private String secret;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            KubernetesClient kubernetes = this.getKubernetes();
            Log log = this.getLog();
            String gogsUser = this.gogsUsername;
            String gogsPwd = this.gogsPassword;
            String repoName = this.repo;
            String webhookUrlValue = this.webhookUrl;
            String webhookSecret = this.secret;
            GitRepoClient gitRepoClient = GitRepoKubernetes.createGitRepoClient((KubernetesClient)this.getKubernetes(), (String)gogsUser, (String)this.gogsPassword);
            if (gitRepoClient == null) {
                this.getLog().error((CharSequence)("No Gogs service found in kubernetes at address " + kubernetes.getMasterUrl() + " namespace " + this.getNamespace()));
            } else {
                Logger logger = LoggerFactory.getLogger(CreateGogsWebhook.class);
                WebHooks.createGogsWebhook((GitRepoClient)gitRepoClient, (Logger)logger, (String)gogsUser, (String)repoName, (String)webhookUrlValue, (String)webhookSecret);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to load environment schemas: " + e, e);
        }
    }
}

