/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.devops;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.devops.ProjectConfig;
import io.fabric8.utils.Maps;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConfigs {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProjectConfigs.class);
    public static final String FILE_NAME = "fabric8.yml";
    public static final String LOCAL_FLOW_FILE_NAME = "Jenkinsfile";

    public static String toYaml(Object dto) throws JsonProcessingException {
        ObjectMapper mapper = ProjectConfigs.createObjectMapper();
        return mapper.writeValueAsString(dto);
    }

    public static ProjectConfig loadFromFolder(File folder) {
        File projectConfigFile = new File(folder, FILE_NAME);
        if (projectConfigFile != null && projectConfigFile.exists() && projectConfigFile.isFile()) {
            LOG.debug("Parsing fabric8 devops project configuration from: " + projectConfigFile.getName());
            try {
                return ProjectConfigs.parseProjectConfig(projectConfigFile);
            }
            catch (IOException e) {
                LOG.warn("Failed to parse " + projectConfigFile + ". " + e, (Throwable)e);
            }
        }
        return new ProjectConfig();
    }

    public static ProjectConfig findFromFolder(File folder) {
        if (folder.isDirectory()) {
            File projectConfigFile = new File(folder, FILE_NAME);
            if (projectConfigFile != null && projectConfigFile.exists() && projectConfigFile.isFile()) {
                return ProjectConfigs.loadFromFolder(folder);
            }
            File parentFile = folder.getParentFile();
            if (parentFile != null) {
                return ProjectConfigs.findFromFolder(parentFile);
            }
        }
        return new ProjectConfig();
    }

    public static ProjectConfig loadFromUrl(String url) {
        if (Strings.isNotBlank((String)url)) {
            try {
                return ProjectConfigs.loadFromUrl(new URL(url));
            }
            catch (MalformedURLException e) {
                LOG.warn("Failed to create URL from: " + url + ". " + e, (Throwable)e);
            }
        }
        return null;
    }

    public static ProjectConfig loadFromUrl(URL url) {
        InputStream input = null;
        try {
            input = url.openStream();
        }
        catch (FileNotFoundException e) {
            LOG.info("No fabric8.yml at URL: " + url);
        }
        catch (IOException e) {
            LOG.warn("Failed to open fabric8.yml file at URL: " + url + ". " + e, (Throwable)e);
        }
        if (input != null) {
            try {
                LOG.info("Parsing fabric8.yml from " + url);
                return ProjectConfigs.parseProjectConfig(input);
            }
            catch (IOException e) {
                LOG.warn("Failed to parse fabric8.yml from " + url + ". " + e, (Throwable)e);
            }
        }
        return null;
    }

    public static boolean hasConfigFile(File folder) {
        File projectConfigFile = new File(folder, FILE_NAME);
        return projectConfigFile != null && projectConfigFile.exists() && projectConfigFile.isFile();
    }

    public static ObjectMapper createObjectMapper() {
        return new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    public static ProjectConfig parseProjectConfig(File file) throws IOException {
        return ProjectConfigs.parseYaml(file, ProjectConfig.class);
    }

    public static ProjectConfig parseProjectConfig(InputStream input) throws IOException {
        return ProjectConfigs.parseYaml(input, ProjectConfig.class);
    }

    public static ProjectConfig parseProjectConfig(String yaml) throws IOException {
        return ProjectConfigs.parseYaml(yaml, ProjectConfig.class);
    }

    private static <T> T parseYaml(File file, Class<T> clazz) throws IOException {
        ObjectMapper mapper = ProjectConfigs.createObjectMapper();
        return (T)mapper.readValue(file, clazz);
    }

    static <T> List<T> parseYamlValues(File file, Class<T> clazz) throws IOException {
        ObjectMapper mapper = ProjectConfigs.createObjectMapper();
        MappingIterator iter = mapper.readerFor(clazz).readValues(file);
        ArrayList<Object> answer = new ArrayList<Object>();
        while (iter.hasNext()) {
            answer.add(iter.next());
        }
        return answer;
    }

    private static <T> T parseYaml(InputStream inputStream, Class<T> clazz) throws IOException {
        ObjectMapper mapper = ProjectConfigs.createObjectMapper();
        return (T)mapper.readValue(inputStream, clazz);
    }

    private static <T> T parseYaml(String yaml, Class<T> clazz) throws IOException {
        ObjectMapper mapper = ProjectConfigs.createObjectMapper();
        return (T)mapper.readValue(yaml, clazz);
    }

    public static boolean saveToFolder(File basedir, ProjectConfig config, boolean overwriteIfExists) throws IOException {
        File file = new File(basedir, FILE_NAME);
        if (file.exists() && !overwriteIfExists) {
            LOG.warn("Not generating " + file + " as it already exists");
            return false;
        }
        return ProjectConfigs.saveConfig(config, file);
    }

    public static boolean saveConfig(ProjectConfig config, File file) throws IOException {
        ProjectConfigs.createObjectMapper().writeValue(file, (Object)config);
        return true;
    }

    public static void configureProperties(ProjectConfig config, Map map) {
        Class<?> clazz = config.getClass();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            LOG.warn("Could not introspect " + clazz.getName() + ". " + e, (Throwable)e);
        }
        if (beanInfo != null) {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor descriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String name;
                Object value;
                Method writeMethod = descriptor.getWriteMethod();
                if (writeMethod == null || (value = map.get(name = descriptor.getName())) == null) continue;
                Object safeValue = null;
                Class<?> propertyType = descriptor.getPropertyType();
                if (propertyType.isInstance(value)) {
                    safeValue = value;
                } else {
                    PropertyEditor editor = descriptor.createPropertyEditor(config);
                    if (editor == null) {
                        editor = PropertyEditorManager.findEditor(propertyType);
                    }
                    if (editor != null) {
                        String text = value.toString();
                        editor.setAsText(text);
                        safeValue = editor.getValue();
                    } else {
                        LOG.warn("Cannot update property " + name + " with value " + value + " of type " + propertyType.getName() + " on " + clazz.getName());
                    }
                }
                if (safeValue == null) continue;
                try {
                    writeMethod.invoke((Object)config, safeValue);
                }
                catch (Exception e) {
                    LOG.warn("Failed to set property " + name + " with value " + value + " on " + clazz.getName() + " " + config + ". " + e, (Throwable)e);
                }
            }
        }
        String flow = null;
        Object flowValue = map.get("pipeline");
        if (flowValue == null) {
            flowValue = map.get("flow");
        }
        if (flowValue != null) {
            flow = flowValue.toString();
        }
        config.setPipeline(flow);
    }

    public static void defaultEnvironments(ProjectConfig config) {
        String buildName;
        if (config != null && Strings.isNotBlank((String)(buildName = config.getBuildName())) && Maps.isNullOrEmpty(config.getEnvironments())) {
            String defaultEnvironmentsText = Systems.getEnvVarOrSystemProperty((String)"FABRIC8_DEFAULT_ENVIRONMENTS", (String)"Testing=${buildName}-testing,Staging=${buildName}-staging,Production=${buildName}-prod");
            String text = Strings.replaceAllWithoutRegex((String)defaultEnvironmentsText, (String)"${buildName}", (String)buildName);
            LinkedHashMap environments = Maps.parseMap((String)text);
            config.setEnvironments(environments);
        }
    }
}

