/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.devops;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ProjectConfig {
    private List<String> flows = new ArrayList<String>();
    private String chatRoom;
    private String issueProjectName;
    private Boolean codeReview;

    public String toString() {
        return "ProjectConfig{flows=" + this.flows + ", chatRoom='" + this.chatRoom + '\'' + ", issueProjectName='" + this.issueProjectName + '\'' + '}';
    }

    public void addFlow(String flow) {
        if (this.flows == null) {
            this.flows = new ArrayList<String>();
        }
        this.flows.add(flow);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.codeReview == null && Strings.isNullOrBlank((String)this.chatRoom) && Strings.isNullOrBlank((String)this.issueProjectName) && (this.flows == null || this.flows.isEmpty());
    }

    public String getChatRoom() {
        return this.chatRoom;
    }

    public void setChatRoom(String chatRoom) {
        this.chatRoom = chatRoom;
    }

    public Boolean getCodeReview() {
        return this.codeReview;
    }

    public void setCodeReview(Boolean codeReview) {
        this.codeReview = codeReview;
    }

    public List<String> getFlows() {
        return this.flows;
    }

    public void setFlows(List<String> flows) {
        this.flows = flows;
    }

    public String getIssueProjectName() {
        return this.issueProjectName;
    }

    public void setIssueProjectName(String issueProjectName) {
        this.issueProjectName = issueProjectName;
    }
}

