/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf.maven;

import com.wordnik.swagger.annotations.Api;
import io.fabric8.cxf.endpoint.SwaggerFeature;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class Java2SwaggerJsonMojo
extends AbstractMojo {
    private String outputFile;
    private Boolean attachSwagger;
    private String classifier;
    private List<String> classResourceNames;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private String outputFileName;
    private String outputFileExtension;
    private String address;
    private ClassLoader resourceClassLoader;

    public void execute() throws MojoExecutionException {
        List<Class<?>> resourceClasses = this.loadResourceClasses();
        ArrayList resourceObjects = new ArrayList();
        for (Class<?> resourceClass : resourceClasses) {
            try {
                resourceObjects.add(resourceClass.newInstance());
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        ArrayList<SwaggerFeature> features = new ArrayList<SwaggerFeature>();
        features.add(new SwaggerFeature());
        JAXRSServerFactoryBean serverFacBean = new JAXRSServerFactoryBean();
        serverFacBean.setAddress(this.address);
        serverFacBean.setServiceBeans(resourceObjects);
        serverFacBean.setFeatures(features);
        Server server = serverFacBean.create();
        InputStream in = null;
        try {
            String res = "";
            for (Class<?> resourceClass : resourceClasses) {
                Api api = resourceClass.getAnnotation(Api.class);
                if (api == null) continue;
                String apiPath = api.value();
                String serverAddress = server.getEndpoint().getEndpointInfo().getAddress();
                String apiDocs = serverAddress + "/api-docs";
                URL url = new URL(apiDocs + apiPath);
                in = url.openStream();
                res = res + Java2SwaggerJsonMojo.getStringFromInputStream(in);
            }
            this.generateJson(resourceClasses, res);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            server.stop();
        }
    }

    private void generateJson(List<Class<?>> resourceClasses, String swagger) throws MojoExecutionException {
        File jsonFile;
        if (this.outputFile == null && this.project != null) {
            String name = null;
            name = this.outputFileName != null ? this.outputFileName : (resourceClasses.size() == 1 ? resourceClasses.get(0).getSimpleName() : "application");
            this.outputFile = (this.project.getBuild().getDirectory() + "/generated/json/" + name + "." + this.outputFileExtension).replace("/", File.separator);
        }
        BufferedWriter writer = null;
        try {
            FileUtils.mkDir((File)new File(this.outputFile).getParentFile());
            writer = new BufferedWriter(new FileWriter(this.outputFile));
            writer.write(swagger);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (this.attachSwagger.booleanValue() && this.outputFile != null && (jsonFile = new File(this.outputFile)).exists()) {
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.project, "json", this.classifier, jsonFile);
            } else {
                this.projectHelper.attachArtifact(this.project, "json", jsonFile);
            }
        }
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        if (this.resourceClassLoader == null) {
            try {
                List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
                URL[] runtimeUrls = new URL[runtimeClasspathElements.size()];
                for (int i = 0; i < runtimeClasspathElements.size(); ++i) {
                    String element = (String)runtimeClasspathElements.get(i);
                    runtimeUrls[i] = new File(element).toURI().toURL();
                }
                this.resourceClassLoader = new URLClassLoader(runtimeUrls, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        return this.resourceClassLoader;
    }

    private List<Class<?>> loadResourceClasses() throws MojoExecutionException {
        ArrayList resourceClasses = new ArrayList(this.classResourceNames.size());
        for (String className : this.classResourceNames) {
            try {
                resourceClasses.add(this.getClassLoader().loadClass(className));
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        return resourceClasses;
    }

    private static String getStringFromInputStream(InputStream in) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int c = 0;
        while ((c = in.read()) != -1) {
            bos.write(c);
        }
        in.close();
        bos.close();
        return bos.toString();
    }
}

