/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import java.io.IOException;
import org.jolokia.jvmagent.JolokiaServer;
import org.jolokia.jvmagent.JvmAgentConfig;

public final class JvmAgent {
    private static JolokiaServer server;
    public static final String JOLOKIA_AGENT_URL = "jolokia.agent";

    private JvmAgent() {
    }

    public static void premain(String agentArgs) {
        JvmAgent.startAgent(new JvmAgentConfig(agentArgs), true);
    }

    public static void agentmain(String agentArgs) {
        JvmAgentConfig config = new JvmAgentConfig(agentArgs);
        if (!config.isModeStop()) {
            JvmAgent.startAgent(config, false);
        } else {
            JvmAgent.stopAgent();
        }
    }

    private static void startAgent(JvmAgentConfig pConfig, boolean pLazy) {
        try {
            server = new JolokiaServer(pConfig, pLazy);
            server.start();
            JvmAgent.setStateMarker();
            System.out.println("Jolokia: Agent started with URL " + server.getUrl());
        }
        catch (RuntimeException exp) {
            System.err.println("Could not start Jolokia agent: " + exp);
        }
        catch (IOException exp) {
            System.err.println("Could not start Jolokia agent: " + exp);
        }
    }

    private static void stopAgent() {
        try {
            server.stop();
            JvmAgent.clearStateMarker();
        }
        catch (RuntimeException exp) {
            System.err.println("Could not stop Jolokia agent: " + exp);
        }
    }

    private static void setStateMarker() {
        String url = server.getUrl();
        System.setProperty(JOLOKIA_AGENT_URL, url);
    }

    private static void clearStateMarker() {
        System.clearProperty(JOLOKIA_AGENT_URL);
        System.out.println("Jolokia: Agent stopped");
    }
}

