/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent.strategy.trace;

import io.fabric8.apmagent.ApmAgent;
import io.fabric8.apmagent.ClassInfo;
import io.fabric8.apmagent.strategy.trace.ApmMethodVisitor;
import io.fabric8.apmagent.strategy.trace.TraceStrategy;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmClassVisitor
extends ClassVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ApmAgent.class);
    private final TraceStrategy traceStrategy;
    private final ClassInfo classInfo;

    public ApmClassVisitor(TraceStrategy traceStrategy, ClassVisitor cv, ClassInfo classInfo) {
        super(327680, cv);
        this.traceStrategy = traceStrategy;
        this.classInfo = classInfo;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        try {
            String methodDescription = this.getDescription(desc);
            this.classInfo.addMethod(name, methodDescription);
            if (this.canProfileMethod(name, desc) && this.traceStrategy.isAudit(this.classInfo.getClassName(), name)) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                ApmMethodVisitor methodVisitor = new ApmMethodVisitor(mv, this.classInfo.getClassName(), name + methodDescription);
                this.classInfo.addTransformedMethod(name, methodDescription);
                return methodVisitor;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOG.error("Failed to visitMethod " + name, e);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private boolean canProfileMethod(String methodName, String methodDescriptor) {
        if (methodDescriptor != null) {
            Type[] parameterTypes = Type.getArgumentTypes(methodDescriptor);
            if (methodName.equals("<init>") || methodName.equals("<clinit>")) {
                return false;
            }
            if (methodName.startsWith("is") || methodName.startsWith("get") && (parameterTypes == null || parameterTypes.length == 0)) {
                return false;
            }
            return !methodName.startsWith("set") || parameterTypes == null || parameterTypes.length != 1;
        }
        return false;
    }

    private String getDescription(String desc) {
        String result;
        Type[] parameterTypes = Type.getArgumentTypes(desc);
        if (parameterTypes == null || parameterTypes.length == 0) {
            result = "()";
        } else {
            result = "(";
            for (int i = 0; i < parameterTypes.length; ++i) {
                result = result + parameterTypes[i].getClassName();
                if (i + 1 >= parameterTypes.length) continue;
                result = result + ",";
            }
            result = result + ")";
        }
        Type type = Type.getReturnType(desc);
        result = type == null ? result + " void" : result + " " + type.getClassName();
        return result;
    }
}

