/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent.metrics;

import io.fabric8.apmagent.ApmConfiguration;
import io.fabric8.apmagent.metrics.ApmAgentContext;
import io.fabric8.apmagent.metrics.MethodMetrics;
import io.fabric8.apmagent.metrics.MonitoredThreadMethodMetrics;
import io.fabric8.apmagent.metrics.ThreadContextMethodMetrics;
import io.fabric8.apmagent.metrics.ThreadContextMethodMetricsStack;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class ThreadMetrics {
    private final AtomicReference<ThreadContextMethodMetricsStack> methodStackRef;
    private final ApmAgentContext apmAgentContext;
    private final ThreadInfo threadInfo;
    private final Thread thread;
    private final ThreadMXBean threadMXBean;
    private final ConcurrentMap<String, ThreadContextMethodMetrics> methods = new ConcurrentHashMap<String, ThreadContextMethodMetrics>();
    private final MonitoredThreadMethodMetrics monitoredThreadMethodMetrics;

    public ThreadMetrics(ApmAgentContext apmAgentContext, Thread thread) {
        this.methodStackRef = new AtomicReference<ThreadContextMethodMetricsStack>(new ThreadContextMethodMetricsStack());
        this.apmAgentContext = apmAgentContext;
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.threadInfo = this.threadMXBean.getThreadInfo(thread.getId());
        this.thread = thread;
        ApmConfiguration configuration = apmAgentContext.getConfiguration();
        this.monitoredThreadMethodMetrics = new MonitoredThreadMethodMetrics(thread, apmAgentContext);
        this.monitoredThreadMethodMetrics.setMonitorSize(configuration.getThreadMetricDepth());
    }

    public String getName() {
        return this.thread.getName() + "[" + this.thread.getId() + "]";
    }

    Thread getThread() {
        return this.thread;
    }

    public boolean isDead() {
        return !this.thread.isAlive();
    }

    public long getCpuTime() {
        return this.threadMXBean.getThreadCpuTime(this.thread.getId());
    }

    public long getUserTime() {
        return this.threadMXBean.getThreadUserTime(this.thread.getId());
    }

    public ThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public void setMonitorSize(int monitorSize) {
        this.monitoredThreadMethodMetrics.setMonitorSize(monitorSize);
    }

    public void enter(String methodName, boolean alwaysActive) {
        ThreadContextMethodMetrics threadContextMethodMetrics = (ThreadContextMethodMetrics)this.methods.get(methodName);
        if (threadContextMethodMetrics == null) {
            threadContextMethodMetrics = new ThreadContextMethodMetrics(this.thread, this.methodStackRef, methodName);
            threadContextMethodMetrics.setActive(this.apmAgentContext.isMonitorByDefault());
            this.methods.putIfAbsent(methodName, threadContextMethodMetrics);
        }
        if (alwaysActive || threadContextMethodMetrics.isActive()) {
            threadContextMethodMetrics.onEnter();
        }
    }

    public long exit(String methodName, boolean alwaysActive) {
        long result = -1L;
        ThreadContextMethodMetrics threadContextMethodMetrics = (ThreadContextMethodMetrics)this.methods.get(methodName);
        if (threadContextMethodMetrics != null) {
            if (alwaysActive || threadContextMethodMetrics.isActive()) {
                result = threadContextMethodMetrics.onExit();
            }
        } else {
            this.methodStackRef.set(new ThreadContextMethodMetricsStack());
        }
        return result;
    }

    public String toString() {
        return "ThreadMetrics:" + this.getName();
    }

    public void destroy() {
        this.monitoredThreadMethodMetrics.destroy();
    }

    public ThreadContextMethodMetrics remove(String fullMethodName) {
        ThreadContextMethodMetrics result = (ThreadContextMethodMetrics)this.methods.remove(fullMethodName);
        return result;
    }

    public void calculateMethodMetrics() {
        List<? extends MethodMetrics> list = MethodMetrics.sortedMetrics(this.methods.values());
        this.monitoredThreadMethodMetrics.calculateMethodMetrics(list);
    }

    public void setActive(String methodName, boolean flag) {
        ThreadContextMethodMetrics threadContextMethodMetrics = (ThreadContextMethodMetrics)this.methods.get(methodName);
        if (threadContextMethodMetrics != null) {
            threadContextMethodMetrics.setActive(flag);
        }
    }

    public boolean isActive(String methodName) {
        ThreadContextMethodMetrics threadContextMethodMetrics = (ThreadContextMethodMetrics)this.methods.get(methodName);
        return threadContextMethodMetrics != null ? threadContextMethodMetrics.isActive() : false;
    }
}

