/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent.metrics;

import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MethodMetrics {
    protected final Timer timer;
    private final String name;
    private final double rateFactor;
    private final double durationFactor;
    private int percentage;
    private boolean active = true;

    public MethodMetrics(String name) {
        this.name = name;
        this.timer = new Timer();
        this.rateFactor = TimeUnit.SECONDS.toSeconds(1L);
        this.durationFactor = 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long getCount() {
        return this.timer.getCount();
    }

    public double getMeanRate() {
        return this.timer.getMeanRate() * this.rateFactor;
    }

    public double getOneMinuteRate() {
        return this.timer.getOneMinuteRate() * this.rateFactor;
    }

    public double getFiveMinuteRate() {
        return this.timer.getFiveMinuteRate() * this.rateFactor;
    }

    public double getFifteenMinuteRate() {
        return this.timer.getFifteenMinuteRate() * this.rateFactor;
    }

    public double getMin() {
        return (double)this.timer.getSnapshot().getMin() * this.durationFactor;
    }

    public double getMax() {
        return (double)this.timer.getSnapshot().getMax() * this.durationFactor;
    }

    public double getMean() {
        return this.timer.getSnapshot().getMean() * this.durationFactor;
    }

    public double getStdDev() {
        return this.timer.getSnapshot().getStdDev() * this.durationFactor;
    }

    public double get50thPercentile() {
        return this.timer.getSnapshot().getMedian() * this.durationFactor;
    }

    public double get75thPercentile() {
        return this.timer.getSnapshot().get75thPercentile() * this.durationFactor;
    }

    public double get95thPercentile() {
        return this.timer.getSnapshot().get95thPercentile() * this.durationFactor;
    }

    public double get98thPercentile() {
        return this.timer.getSnapshot().get98thPercentile() * this.durationFactor;
    }

    public double get99thPercentile() {
        return this.timer.getSnapshot().get99thPercentile() * this.durationFactor;
    }

    public double get999thPercentile() {
        return this.timer.getSnapshot().get999thPercentile() * this.durationFactor;
    }

    public double getLoad() {
        return (double)this.timer.getSnapshot().size() * this.getMean();
    }

    public int getPercentage() {
        return this.percentage;
    }

    public void setPercentage(int percentage) {
        this.percentage = percentage;
    }

    public long[] values() {
        return this.timer.getSnapshot().getValues();
    }

    public void update(long elapsed) {
        if (elapsed >= 0L) {
            this.timer.update(elapsed, TimeUnit.NANOSECONDS);
        }
    }

    public String toString() {
        return "MethodMetrics:" + this.getName();
    }

    public static List<? extends MethodMetrics> sortedMetrics(Collection<? extends MethodMetrics> collection) {
        ArrayList<? extends MethodMetrics> list = new ArrayList<MethodMetrics>(collection);
        Collections.sort(list, new Comparator<MethodMetrics>(){

            @Override
            public int compare(MethodMetrics methodMetrics1, MethodMetrics methodMetrics2) {
                return (int)methodMetrics2.getLoad() - (int)methodMetrics1.getLoad();
            }
        });
        int totalLoad = 0;
        for (MethodMetrics methodMetrics : list) {
            totalLoad = (int)((double)totalLoad + methodMetrics.getLoad());
        }
        for (MethodMetrics methodMetrics : list) {
            int percentage = (int)(methodMetrics.getLoad() * 100.0 / (double)totalLoad);
            methodMetrics.setPercentage(percentage);
        }
        return list;
    }
}

