/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent.metrics;

import io.fabric8.apmagent.metrics.ThreadContextMethodMetrics;

class ThreadContextMethodMetricsStack {
    private ThreadContextMethodMetrics[] stack = new ThreadContextMethodMetrics[2];
    private int pointer;

    ThreadContextMethodMetricsStack() {
    }

    ThreadContextMethodMetrics push(ThreadContextMethodMetrics value) {
        if (this.pointer + 1 >= this.stack.length) {
            this.resizeStack(this.stack.length * 2);
        }
        this.stack[this.pointer++] = value;
        return value;
    }

    ThreadContextMethodMetrics pop() {
        ThreadContextMethodMetrics result = this.stack[--this.pointer];
        this.stack[this.pointer] = null;
        return result;
    }

    private void resizeStack(int newCapacity) {
        ThreadContextMethodMetrics[] newStack = new ThreadContextMethodMetrics[newCapacity];
        System.arraycopy(this.stack, 0, newStack, 0, Math.min(this.pointer, newCapacity));
        this.stack = newStack;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < this.pointer; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.stack[i].getName());
        }
        result.append(']');
        return result.toString();
    }
}

