/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.apmagent.metrics;

import io.fabric8.apmagent.ApmAgent;
import io.fabric8.apmagent.ApmConfiguration;
import io.fabric8.apmagent.ClassInfo;
import io.fabric8.apmagent.MethodDescription;
import io.fabric8.apmagent.metrics.MethodMetrics;
import io.fabric8.apmagent.metrics.MethodMetricsProxy;
import io.fabric8.apmagent.metrics.MonitoredMethodMetrics;
import io.fabric8.apmagent.metrics.ThreadMetrics;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jolokia.jmx.JolokiaMBeanServerUtil;
import org.jolokia.jvmagent.JolokiaServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmAgentContext {
    private static final Logger LOG = LoggerFactory.getLogger(ApmAgent.class);
    private final String DEFAULT_DOMAIN = "io.fabric8.apmagent";
    private final long HOUSE_KEEPING_TIME = TimeUnit.SECONDS.toMillis(2L);
    private final ConcurrentMap<String, ClassInfo> allMethods = new ConcurrentHashMap<String, ClassInfo>();
    private AtomicBoolean initialized = new AtomicBoolean();
    private AtomicBoolean started = new AtomicBoolean();
    private ConcurrentMap<Thread, ThreadMetrics> threadMetricsMap = new ConcurrentHashMap<Thread, ThreadMetrics>();
    private ConcurrentMap<String, MethodMetrics> methodMetricsMap = new ConcurrentHashMap<String, MethodMetrics>();
    private ConcurrentMap<Object, ObjectName> objectNameMap = new ConcurrentHashMap<Object, ObjectName>();
    private MBeanServer mBeanServer;
    private JolokiaServer jolokiaServer;
    private final ApmAgent apmAgent;
    private ObjectName agentObjectName;
    private ObjectName configurationObjectName;
    private final ApmConfiguration configuration;
    private final MonitoredMethodMetrics monitoredMethodMetrics;
    private AtomicBoolean doHouseKeeping = new AtomicBoolean();
    private Thread backgroundThread;
    private boolean monitorByDefault = true;

    public ApmAgentContext(ApmAgent agent) {
        this.apmAgent = agent;
        this.configuration = agent.getConfiguration();
        this.monitoredMethodMetrics = new MonitoredMethodMetrics(this);
        this.monitoredMethodMetrics.setMonitorSize(this.configuration.getMethodMetricDepth());
    }

    public void enterMethod(Thread currentThread, String fullMethodName, boolean alwaysActive) {
        if (this.isInitialized()) {
            ThreadMetrics threadMetrics = (ThreadMetrics)this.threadMetricsMap.get(currentThread);
            if (threadMetrics == null) {
                threadMetrics = new ThreadMetrics(this, currentThread);
                this.threadMetricsMap.put(currentThread, threadMetrics);
            }
            threadMetrics.enter(fullMethodName, alwaysActive);
            MethodMetrics methodMetrics = (MethodMetrics)this.methodMetricsMap.get(fullMethodName);
            if (methodMetrics == null) {
                methodMetrics = new MethodMetrics(fullMethodName);
                methodMetrics.setActive(this.isMonitorByDefault());
                this.methodMetricsMap.putIfAbsent(fullMethodName, methodMetrics);
            }
        }
    }

    public void exitMethod(Thread currentThread, String methodName, boolean alwaysActive) {
        if (this.isInitialized()) {
            MethodMetrics methodMetrics;
            ThreadMetrics threadMetrics = (ThreadMetrics)this.threadMetricsMap.get(currentThread);
            long elapsed = -1L;
            if (threadMetrics != null) {
                elapsed = threadMetrics.exit(methodName, alwaysActive);
            }
            if (elapsed >= 0L && (methodMetrics = (MethodMetrics)this.methodMetricsMap.get(methodName)) != null) {
                methodMetrics.update(elapsed);
            }
            this.doHouseKeeping();
        }
    }

    public void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            try {
                this.agentObjectName = new ObjectName("io.fabric8.apmagent", "type", "apmAgent");
                this.registerMBean(this.agentObjectName, this.apmAgent);
                this.configurationObjectName = new ObjectName("io.fabric8.apmagent", "type", "configuration");
                this.registerMBean(this.configurationObjectName, this.configuration);
            }
            catch (Throwable e) {
                LOG.warn("Failed to register ApmAgent mbeans with mBeanServer due " + e.getMessage(), e);
            }
        }
    }

    public void start() {
        if (this.initialized.get() && this.started.compareAndSet(false, true)) {
            this.backgroundThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (ApmAgentContext.this.started.get()) {
                        try {
                            Thread.sleep(ApmAgentContext.this.HOUSE_KEEPING_TIME);
                            ApmAgentContext.this.doHouseKeeping.set(true);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }, "Fabric8-ApmAgent-BackgroundThread");
            this.backgroundThread.setDaemon(true);
            this.backgroundThread.start();
        }
    }

    void doHouseKeeping() {
        if (this.doHouseKeeping.compareAndSet(true, false)) {
            try {
                List<ThreadMetrics> threadMetricsList = this.getThreadMetrics();
                for (ThreadMetrics tm : threadMetricsList) {
                    if (!tm.isDead()) continue;
                    tm.destroy();
                    this.threadMetricsMap.remove(tm.getThread());
                }
                this.monitoredMethodMetrics.calculateMethodMetrics(this.getMethodMetrics());
                for (ThreadMetrics threadMetrics : threadMetricsList) {
                    threadMetrics.calculateMethodMetrics();
                }
            }
            catch (Throwable e) {
                LOG.warn("Error during housekeeping due " + e.getMessage() + ". This exception is ignored.", e);
            }
        }
    }

    public void stop() {
        if (this.initialized.get() && this.started.compareAndSet(true, false)) {
            for (ObjectName objectName : this.objectNameMap.values()) {
                this.unregisterMBean(objectName);
            }
            this.objectNameMap.clear();
            this.methodMetricsMap.clear();
            this.threadMetricsMap.clear();
        }
    }

    public void shutDown() {
        if (this.initialized.compareAndSet(true, false)) {
            this.stop();
            this.unregisterMBean(this.configurationObjectName);
            this.unregisterMBean(this.agentObjectName);
            if (this.jolokiaServer != null) {
                this.jolokiaServer.stop();
                this.jolokiaServer = null;
            }
            this.mBeanServer = null;
        }
    }

    public ClassInfo getClassInfo(String className) {
        String key = className.replace('/', '.');
        ClassInfo result = (ClassInfo)this.allMethods.get(key);
        if (result == null) {
            ClassInfo classInfo = new ClassInfo();
            classInfo.setClassName(key);
            result = this.allMethods.putIfAbsent(key, classInfo);
            if (result == null) {
                result = classInfo;
            }
        }
        return result;
    }

    public List<String> getTransformedMethods() {
        ArrayList<String> result = new ArrayList<String>();
        for (ClassInfo classInfo : this.allMethods.values()) {
            for (String methodName : classInfo.getAllTransformedMethodNames()) {
                result.add(classInfo.getClassName() + "@" + methodName);
            }
        }
        return result;
    }

    public List<String> getAllMethods() {
        ArrayList<String> result = new ArrayList<String>();
        for (ClassInfo classInfo : this.allMethods.values()) {
            for (String methodName : classInfo.getAllMethodNames()) {
                result.add(classInfo.getClassName() + "@" + methodName);
            }
        }
        return result;
    }

    public List<ThreadMetrics> getThreadMetrics() {
        ArrayList<ThreadMetrics> result = new ArrayList<ThreadMetrics>(this.threadMetricsMap.values());
        Collections.sort(result, new Comparator<ThreadMetrics>(){

            @Override
            public int compare(ThreadMetrics threadMetrics1, ThreadMetrics threadMetrics2) {
                return (int)(threadMetrics2.getCpuTime() - threadMetrics1.getCpuTime());
            }
        });
        return result;
    }

    public List<? extends MethodMetrics> getMethodMetrics() {
        return MethodMetrics.sortedMetrics(this.methodMetricsMap.values());
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public ApmConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isMonitorByDefault() {
        return this.monitorByDefault;
    }

    public void setMonitorByDefault(boolean monitorByDefault) {
        this.monitorByDefault = monitorByDefault;
    }

    public void setActive(String fullMethodName, boolean flag) {
        if (this.isInitialized()) {
            for (ThreadMetrics threadMetrics : this.threadMetricsMap.values()) {
                threadMetrics.setActive(fullMethodName, flag);
            }
            MethodMetrics methodMetrics = (MethodMetrics)this.methodMetricsMap.get(fullMethodName);
            if (methodMetrics != null) {
                methodMetrics.setActive(flag);
            }
        }
    }

    public List<ClassInfo> buildDeltaList() {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : this.allMethods.values()) {
            if (classInfo.isTransformed()) {
                if (this.configuration.isAudit(classInfo.getClassName())) {
                    boolean retransform = false;
                    Set<String> transformedMethodNames = classInfo.getAllTransformedMethodNames();
                    for (String methodName : transformedMethodNames) {
                        if (this.configuration.isAudit(classInfo.getClassName(), methodName)) continue;
                        retransform = true;
                        break;
                    }
                    if (!retransform) {
                        Set<String> allMethodNames = classInfo.getAllMethodNames();
                        for (String methodName : allMethodNames) {
                            if (transformedMethodNames.contains(methodName) || !this.configuration.isAudit(classInfo.getClassName(), methodName)) continue;
                            retransform = true;
                            break;
                        }
                    }
                    if (!retransform) continue;
                    result.add(classInfo);
                    continue;
                }
                result.add(classInfo);
                continue;
            }
            if (!this.configuration.isAudit(classInfo.getClassName()) || !classInfo.isCanTransform()) continue;
            result.add(classInfo);
        }
        return result;
    }

    public void resetMethods(ClassInfo classInfo) {
        Collection<MethodDescription> list = classInfo.getTransformedMethodDescriptions();
        for (MethodDescription methodDescription : list) {
            if (this.configuration.isAudit(classInfo.getClassName(), methodDescription.getMethodName())) continue;
            this.remove(methodDescription);
        }
    }

    public void resetAll(ClassInfo classInfo) {
        Collection<MethodDescription> list = classInfo.getTransformedMethodDescriptions();
        for (MethodDescription methodDescription : list) {
            this.remove(methodDescription);
        }
        classInfo.resetTransformed();
    }

    public void methodMetricsDepthChanged() {
        this.monitoredMethodMetrics.setMonitorSize(this.configuration.getMethodMetricDepth());
    }

    public void threadMetricsDepthChanged() {
        for (ThreadMetrics threadMetrics : this.threadMetricsMap.values()) {
            threadMetrics.setMonitorSize(this.configuration.getThreadMetricDepth());
        }
    }

    private void remove(MethodDescription methodDescription) {
        this.methodMetricsMap.remove(methodDescription.getFullMethodName());
        for (ThreadMetrics threadMetrics : this.threadMetricsMap.values()) {
            threadMetrics.remove(methodDescription.getFullMethodName());
        }
    }

    protected ObjectInstance registerMBean(ObjectName objectName, Object object) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        MBeanServer server = this.getMBeanServer();
        if (server != null && !server.isRegistered(objectName)) {
            return server.registerMBean(object, objectName);
        }
        return null;
    }

    protected void unregisterMBean(ObjectName objectName) {
        MBeanServer beanServer = this.getMBeanServer();
        if (objectName != null && beanServer != null && beanServer.isRegistered(objectName)) {
            try {
                beanServer.unregisterMBean(objectName);
            }
            catch (Throwable e) {
                LOG.warn("Failed to unregister " + objectName + " due " + e.getMessage() + ". This exception is ignored.", e);
            }
        }
    }

    void registerMethodMetricsMBean(int rank, MethodMetricsProxy methodMetrics) {
        try {
            ObjectName objectName = new ObjectName("io.fabric8.apmagent:type=MethodMetrics,rank=" + ObjectName.quote("rank" + rank));
            LOG.debug("registered {}", (Object)objectName);
            this.registerMBean(objectName, methodMetrics);
            this.objectNameMap.put(methodMetrics, objectName);
        }
        catch (Throwable e) {
            LOG.warn("Failed to register mbean " + methodMetrics.toString() + " due " + e.getMessage() + ". This exception is ignored.", e);
        }
    }

    void registerMethodMetricsMBean(String threadName, long threadId, int rank, MethodMetricsProxy threadMetrics) {
        try {
            String threadIdentity = threadName + "[" + threadId + "]";
            ObjectName objectName = new ObjectName("io.fabric8.apmagent:type=ThreadContextMetrics,threadName=" + ObjectName.quote(threadIdentity) + ",rank=" + ObjectName.quote("rank" + rank));
            this.registerMBean(objectName, threadMetrics);
            this.objectNameMap.put(threadMetrics, objectName);
        }
        catch (Throwable e) {
            LOG.warn("Failed to register mbean " + threadMetrics.toString() + " due " + e.getMessage() + ". This exception is ignored.", e);
        }
    }

    void unregisterMethodMetricsMBean(MethodMetricsProxy methodMetrics) {
        ObjectName objectName = (ObjectName)this.objectNameMap.remove(methodMetrics);
        this.unregisterMBean(objectName);
    }

    private synchronized MBeanServer getMBeanServer() {
        if (this.mBeanServer == null) {
            this.mBeanServer = this.configuration.isUsePlatformMBeanServer() ? ManagementFactory.getPlatformMBeanServer() : JolokiaMBeanServerUtil.getJolokiaMBeanServer();
        }
        return this.mBeanServer;
    }
}

