/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.web;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Version;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.internal.JsonHelper;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.ops4j.pax.web.service.spi.ServletEvent;
import org.ops4j.pax.web.service.spi.ServletListener;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.ops4j.pax.web.service.spi.WebListener;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.web", label="Fabric8 Web Registration Handler", immediate=true, metatype=false)
@Service(value={WebListener.class, ServletListener.class, ConnectionStateListener.class})
public final class FabricWebRegistrationHandler
extends AbstractComponent
implements WebListener,
ServletListener,
ConnectionStateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricWebRegistrationHandler.class);
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @GuardedBy(value="ConcurrentMap")
    private final ConcurrentMap<Bundle, WebEvent> webEvents = new ConcurrentHashMap<Bundle, WebEvent>();
    @GuardedBy(value="ConcurrentMap")
    private final ConcurrentMap<Bundle, Map<String, ServletEvent>> servletEvents = new ConcurrentHashMap<Bundle, Map<String, ServletEvent>>();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (this.isValid()) {
            switch (newState) {
                case CONNECTED: 
                case RECONNECTED: {
                    this.replay();
                }
            }
        }
    }

    public void webEvent(WebEvent webEvent) {
        if (this.isValid()) {
            this.webEvents.put(webEvent.getBundle(), webEvent);
            switch (webEvent.getType()) {
                case 1: {
                    break;
                }
                case 2: {
                    this.registerWebapp(((FabricService)this.fabricService.get()).getCurrentContainer(), webEvent);
                    break;
                }
                default: {
                    this.unRegisterWebapp(((FabricService)this.fabricService.get()).getCurrentContainer(), webEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void servletEvent(ServletEvent servletEvent) {
        if (this.isValid()) {
            HashMap<String, ServletEvent> events;
            WebEvent webEvent = (WebEvent)this.webEvents.get(servletEvent.getBundle());
            if (webEvent != null || servletEvent.getAlias() == null) {
                return;
            }
            ConcurrentMap<Bundle, Map<String, ServletEvent>> concurrentMap = this.servletEvents;
            synchronized (concurrentMap) {
                events = (HashMap<String, ServletEvent>)this.servletEvents.get(servletEvent.getBundle());
                if (events == null) {
                    events = new HashMap<String, ServletEvent>();
                    this.servletEvents.put(servletEvent.getBundle(), events);
                }
            }
            events.put(servletEvent.getAlias(), servletEvent);
            if (((CuratorFramework)this.curator.get()).getZookeeperClient().isConnected()) {
                switch (servletEvent.getType()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.registerServlet(((FabricService)this.fabricService.get()).getCurrentContainer(), servletEvent);
                        break;
                    }
                    default: {
                        this.unregisterServlet(((FabricService)this.fabricService.get()).getCurrentContainer(), servletEvent);
                    }
                }
            }
        }
    }

    private void replay() {
        for (Map.Entry entry : this.webEvents.entrySet()) {
            this.webEvent((WebEvent)entry.getValue());
        }
        for (Map.Entry entry : this.servletEvents.entrySet()) {
            Map servletEventMap = (Map)entry.getValue();
            for (Map.Entry sentry : servletEventMap.entrySet()) {
                this.servletEvent((ServletEvent)sentry.getValue());
            }
        }
    }

    private void registerServlet(Container container, ServletEvent servletEvent) {
        String id = container.getId();
        Version version = container.getVersion();
        String versionId = version != null ? version.getId() : null;
        String url = "${zk:" + id + "/http}" + servletEvent.getAlias();
        String bundleName = servletEvent.getBundle().getSymbolicName();
        String bundleVersion = servletEvent.getBundle().getVersion().toString();
        String name = servletEvent.getBundle().getSymbolicName();
        this.setJolokiaUrl(container, url, name);
        String json = "{\"id\":" + JsonHelper.jsonEncodeString((String)id) + ",\"services\":[" + JsonHelper.jsonEncodeString((String)url) + "]" + ",\"container\":" + JsonHelper.jsonEncodeString((String)id) + ",\"bundleName\":" + JsonHelper.jsonEncodeString((String)bundleName) + ",\"bundleVersion\":" + JsonHelper.jsonEncodeString((String)bundleVersion) + ",\"version\":" + JsonHelper.jsonEncodeString((String)versionId) + "}";
        try {
            if (!servletEvent.getAlias().equals("/")) {
                String path = this.createServletPath(servletEvent, id, bundleName, bundleVersion);
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path, (String)json, (CreateMode)CreateMode.EPHEMERAL);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to register servlet {}.", (Object)servletEvent.getAlias(), (Object)e);
        }
    }

    private void unregisterServlet(Container container, ServletEvent servletEvent) {
        try {
            String bundleName = servletEvent.getBundle().getSymbolicName();
            String bundleVersion = servletEvent.getBundle().getVersion().toString();
            this.clearJolokiaUrl(container, bundleName);
            String id = container.getId();
            if (!servletEvent.getAlias().equals("/")) {
                String path = this.createServletPath(servletEvent, id, bundleName, bundleVersion);
                ZooKeeperUtils.delete((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path);
            }
        }
        catch (KeeperException.NoNodeException e) {
        }
        catch (Exception e) {
            LOGGER.error("Failed to unregister servlet {}.", (Object)servletEvent.getAlias(), (Object)e);
        }
    }

    private void registerWebapp(Container container, WebEvent webEvent) {
        String id = container.getId();
        String url = "${zk:" + id + "/http}" + webEvent.getContextPath();
        String bundleName = webEvent.getBundle().getSymbolicName();
        String bundleVersion = webEvent.getBundle().getVersion().toString();
        this.setJolokiaUrl(container, url, bundleName);
        Version version = container.getVersion();
        String versionId = version != null ? version.getId() : null;
        String json = "{\"id\":" + JsonHelper.jsonEncodeString((String)id) + ",\"services\":[" + JsonHelper.jsonEncodeString((String)url) + "]" + ",\"version\":" + JsonHelper.jsonEncodeString((String)versionId) + ",\"bundleName\":" + JsonHelper.jsonEncodeString((String)bundleName) + ",\"bundleVersion\":" + JsonHelper.jsonEncodeString((String)bundleVersion) + ",\"container\":" + JsonHelper.jsonEncodeString((String)id) + "}";
        try {
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.WEBAPPS_CONTAINER.getPath(new String[]{bundleName, webEvent.getBundle().getVersion().toString(), id}), (String)json, (CreateMode)CreateMode.EPHEMERAL);
        }
        catch (Exception e) {
            LOGGER.error("Failed to register webapp {}.", (Object)webEvent.getContextPath(), (Object)e);
        }
    }

    private void unRegisterWebapp(Container container, WebEvent webEvent) {
        try {
            String name = webEvent.getBundle().getSymbolicName();
            this.clearJolokiaUrl(container, name);
            ZooKeeperUtils.delete((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.WEBAPPS_CONTAINER.getPath(new String[]{name, webEvent.getBundle().getVersion().toString(), container.getId()}));
        }
        catch (KeeperException.NoNodeException e) {
        }
        catch (Exception e) {
            LOGGER.error("Failed to unregister webapp {}.", (Object)webEvent.getContextPath(), (Object)e);
        }
    }

    private String createServletPath(ServletEvent servletEvent, String id, String bundleName, String bundleVersion) {
        StringBuilder path = new StringBuilder();
        path.append("/fabric/registry/clusters/servlets/").append(bundleName).append("/").append(bundleVersion).append(servletEvent.getAlias()).append("/").append(id);
        return path.toString();
    }

    private void setJolokiaUrl(Container container, String url, String symbolicName) {
        if (symbolicName.contains("jolokia")) {
            container.setJolokiaUrl(url);
            System.setProperty("jolokia.agent", url);
        }
    }

    private void clearJolokiaUrl(Container container, String symbolicName) {
        if (symbolicName.contains("jolokia")) {
            container.setJolokiaUrl(null);
            System.clearProperty("jolokia.agent");
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }
}

