/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.agent;

import com.openshift.client.IApplication;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IOpenShiftSSHKey;
import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.api.Container;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.Maps;
import io.fabric8.common.util.Strings;
import io.fabric8.groups.Group;
import io.fabric8.groups.GroupListener;
import io.fabric8.groups.NodeState;
import io.fabric8.groups.internal.ZooKeeperGroup;
import io.fabric8.openshift.CreateOpenshiftContainerOptions;
import io.fabric8.openshift.OpenShiftUtils;
import io.fabric8.openshift.agent.CartridgeGitRepository;
import io.fabric8.openshift.agent.ControllerNode;
import io.fabric8.openshift.agent.DeploymentUpdater;
import io.fabric8.openshift.agent.SshSessionFactoryUtils;
import io.fabric8.zookeeper.ZkPath;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.openshift.agent", label="Fabric8 agent for deploying applications into external OpenShift cartridges", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
public final class OpenShiftDeployAgent
extends AbstractComponent
implements GroupListener<ControllerNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenShiftDeployAgent.class);
    private static final String REALM_PROPERTY_NAME = "realm";
    private static final String ROLE_PROPERTY_NAME = "role";
    private static final String DEFAULT_REALM = "karaf";
    private static final String DEFAULT_ROLE = "admin";
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    private final ExecutorService downloadExecutor = Executors.newSingleThreadExecutor();
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            OpenShiftDeployAgent.this.onConfigurationChanged();
        }
    };
    @GuardedBy(value="volatile")
    private volatile Group<ControllerNode> group;

    @Activate
    void activate(Map<String, ?> configuration) {
        this.group = new ZooKeeperGroup((CuratorFramework)this.curator.get(), ZkPath.OPENSHIFT.getPath(new String[0]), ControllerNode.class);
        this.group.add((GroupListener)this);
        this.group.update((NodeState)this.createState());
        this.group.start();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        try {
            if (this.group != null) {
                this.group.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to remove git server from registry.", (Throwable)e);
        }
        this.shutdownExecutor(this.downloadExecutor);
    }

    private void shutdownExecutor(ExecutorService executor) {
        executor.shutdown();
        try {
            executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        executor.shutdownNow();
    }

    public void groupEvent(Group<ControllerNode> group, GroupListener.GroupEvent event) {
        if (this.isValid()) {
            if (group.isMaster()) {
                LOGGER.info("OpenShiftDeployAgent is the master");
            } else {
                LOGGER.info("OpenShiftDeployAgent is not the master");
            }
            try {
                DataStore dataStore = null;
                if (this.fabricService != null) {
                    dataStore = (DataStore)((FabricService)this.fabricService.get()).adapt(DataStore.class);
                } else {
                    LOGGER.warn("No fabricService yet!");
                }
                if (group.isMaster()) {
                    ControllerNode state = this.createState();
                    group.update((NodeState)state);
                }
                if (dataStore != null) {
                    if (group.isMaster()) {
                        dataStore.trackConfiguration(this.runnable);
                        this.onConfigurationChanged();
                    } else {
                        dataStore.untrackConfiguration(this.runnable);
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConfigurationChanged() {
        Container[] containers;
        LOGGER.info("Configuration has changed; so checking the Fabric managed Java cartridges on OpenShift are up to date");
        for (Container container : containers = ((FabricService)this.fabricService.get()).getContainers()) {
            Profile effectiveProfile = Profiles.getEffectiveProfile((FabricService)((FabricService)this.fabricService.get()), (Profile)container.getOverlayProfile());
            Map openshiftConfiguration = effectiveProfile.getConfiguration("io.fabric8.openshift");
            if (openshiftConfiguration == null) continue;
            DeploymentUpdater deployTask = null;
            try {
                deployTask = this.createDeployTask(container, openshiftConfiguration);
            }
            catch (MalformedURLException e) {
                LOGGER.error("Failed to create DeploymentUpdater. " + e, (Throwable)e);
            }
            if (deployTask == null || !OpenShiftUtils.isFabricManaged(openshiftConfiguration)) continue;
            String containerId = container.getId();
            IOpenShiftConnection connection = OpenShiftUtils.createConnection(container);
            CreateOpenshiftContainerOptions options = OpenShiftUtils.getCreateOptions(container);
            if (connection == null || options == null) {
                LOGGER.warn("Ignoring container which has no openshift connection or options. connection: " + connection + " options: " + (Object)((Object)options));
                continue;
            }
            try {
                String gitUrl;
                IApplication application = OpenShiftUtils.getApplication(container, connection);
                if (application == null || (gitUrl = application.getGitUrl()) == null) continue;
                LOGGER.info("Git URL is " + gitUrl);
                final CartridgeGitRepository repo = new CartridgeGitRepository(containerId);
                final List<IOpenShiftSSHKey> sshkeys = application.getDomain().getUser().getSSHKeys();
                final CredentialsProvider credentials = new CredentialsProvider(){

                    public boolean supports(CredentialItem ... items) {
                        return true;
                    }

                    public boolean isInteractive() {
                        return true;
                    }

                    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
                        LOGGER.info("Credential request " + uri + " items " + Arrays.asList(items));
                        int i = -1;
                        for (CredentialItem item : items) {
                            if (item instanceof CredentialItem.StringType) {
                                int idx;
                                CredentialItem.StringType stringType = (CredentialItem.StringType)item;
                                int n = idx = ++i < sshkeys.size() ? i : 0;
                                if (idx < sshkeys.size()) {
                                    IOpenShiftSSHKey sshKey = (IOpenShiftSSHKey)sshkeys.get(idx);
                                    String passphrase = sshKey.getPublicKey();
                                    LOGGER.info("For item " + item + " index " + i + " using passphrase: " + passphrase);
                                    stringType.setValue(passphrase);
                                    continue;
                                }
                                LOGGER.warn("No ssh keys we can pass into git!");
                                continue;
                            }
                            LOGGER.warn("Unknown CredentialItem " + item);
                        }
                        return true;
                    }
                };
                final DeploymentUpdater finalDeployTask = deployTask;
                SshSessionFactoryUtils.useOpenShiftSessionFactory(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        repo.cloneOrPull(gitUrl, credentials);
                        finalDeployTask.updateDeployment(repo.getGit(), repo.getLocalRepo(), credentials);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Failed to update container " + containerId + ". Reason: " + e, (Throwable)e);
            }
            finally {
                OpenShiftUtils.close(connection);
            }
        }
    }

    private DeploymentUpdater createDeployTask(Container container, Map<String, String> openshiftConfiguration) throws MalformedURLException {
        String webappDir = this.relativePath(container, openshiftConfiguration, "deploy.webapps");
        String deployDir = this.relativePath(container, openshiftConfiguration, "deploy.jars");
        if (webappDir != null || deployDir != null) {
            FabricService fabric = (FabricService)this.fabricService.get();
            DownloadManager downloadManager = DownloadManagers.createDownloadManager(fabric, this.downloadExecutor);
            DeploymentUpdater deploymentUpdater = new DeploymentUpdater(downloadManager, fabric, container, webappDir, deployDir);
            deploymentUpdater.setRepositories(Maps.stringValue(openshiftConfiguration, (String)"repositories", (String)"https://repo.fusesource.com/nexus/content/groups/ea@id=fuseearlyaccess, http://repository.jboss.org/nexus/content/groups/public@id=jboss-public"));
            deploymentUpdater.setCopyFilesIntoGit(Maps.booleanValue(openshiftConfiguration, (String)"copy.binaries.to.git", (boolean)false));
            return deploymentUpdater;
        }
        return null;
    }

    private String relativePath(Container container, Map<String, String> configuration, String propertyName) {
        String value = Maps.stringValue(configuration, (String)propertyName);
        if (Strings.isNotBlank((String)value)) {
            if (value.startsWith("..") || value.startsWith("/") || value.startsWith(File.separator)) {
                throw new IllegalStateException("Invalid relative path '" + value + "' for property " + propertyName + " for container " + container.getId());
            }
            return value;
        }
        return null;
    }

    private ControllerNode createState() {
        ControllerNode state = new ControllerNode();
        return state;
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }
}

