/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileService;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-set-default", scope="fabric", description="Set the new default version (must be one of the existing versions)", detailedDescription="classpath:versionSetDefault.txt")
public class VersionSetDefaultAction
extends AbstractAction {
    @Argument(index=0, description="Version number to use as new default version.", required=true)
    private String versionId;
    private final FabricService fabricService;
    private final ProfileService profileService;

    VersionSetDefaultAction(FabricService fabricService) {
        this.fabricService = fabricService;
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
    }

    protected Object doExecute() throws Exception {
        this.profileService.getRequiredVersion(this.versionId);
        String defaultId = this.fabricService.getDefaultVersionId();
        if (this.versionId.compareTo(defaultId) == 0) {
            System.out.println("Version " + this.versionId + " is already default version");
        } else {
            this.fabricService.setDefaultVersionId(this.versionId);
            System.out.println("Changed default version from " + defaultId + " to " + this.versionId);
        }
        return null;
    }
}

