/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.internal.RequirementsJson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="requirements-export", scope="fabric", description="Exports the current requirements metadata to a JSON file")
public class RequirementsExportAction
extends AbstractAction {
    @Argument(index=0, required=true, description="Output file name")
    protected File outputFile;
    private final FabricService fabricService;

    RequirementsExportAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        this.outputFile.getParentFile().mkdirs();
        FabricRequirements requirements = this.getFabricService().getRequirements();
        RequirementsJson.writeRequirements((OutputStream)new FileOutputStream(this.outputFile), (FabricRequirements)requirements);
        System.out.println("Exported the fabric requirements to " + this.outputFile.getCanonicalPath());
        return null;
    }
}

