/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ContainerCompleter;
import io.fabric8.commands.ContainerDeleteAction;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"container-delete"})})
public class ContainerDelete
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "container-delete";
    public static final String DESCRIPTION = "Stops and deletes an existing container";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=ContainerCompleter.class, bind="bindContainerCompleter", unbind="unbindContainerCompleter")
    private ContainerCompleter containerCompleter;

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new ContainerDeleteAction((FabricService)this.fabricService.get(), (RuntimeProperties)this.runtimeProperties.get());
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindContainerCompleter(ContainerCompleter completer) {
        this.bindCompleter((Completer)completer);
    }

    void unbindContainerCompleter(ContainerCompleter completer) {
        this.unbindCompleter((Completer)completer);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }
}

