/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.httpclient.request;

import com.openshift.internal.client.httpclient.EncodingException;
import com.openshift.internal.client.httpclient.request.IMediaType;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.ParameterValue;
import com.openshift.internal.client.httpclient.request.ParameterValueArray;
import com.openshift.internal.client.httpclient.request.ParameterValueMap;
import com.openshift.internal.client.httpclient.request.StringValue;
import com.openshift.internal.client.utils.UrlUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormUrlEncodedMediaType
implements IMediaType {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormUrlEncodedMediaType.class);
    private static final String UTF8 = "UTF-8";
    private boolean firstParameter = true;

    @Override
    public String getType() {
        return "application/x-www-form-urlencoded";
    }

    @Override
    public void writeTo(ParameterValueMap parameterMap, OutputStream out) throws EncodingException {
        try {
            this.firstParameter = true;
            for (Parameter parameter : ((Map)parameterMap.getValue()).values()) {
                this.writeTo(parameter.getName(), (ParameterValue)parameter.getValue(), out);
            }
        }
        catch (IOException e) {
            throw new EncodingException(MessageFormat.format("Could not encode parameters {0}", parameterMap.toString()), e);
        }
    }

    private void writeTo(String name, ParameterValueMap parameterMap, OutputStream out) throws IOException {
        for (Parameter parameter : ((Map)parameterMap.getValue()).values()) {
            String childName = name + '[' + parameter.getName() + ']';
            this.writeTo(childName, (ParameterValue)parameter.getValue(), out);
        }
    }

    private void writeTo(String name, ParameterValue<?> value, OutputStream out) throws IOException {
        if (StringValue.class.isAssignableFrom(value.getClass())) {
            this.writeTo(name, (StringValue)value, out);
        } else if (ParameterValueArray.class.isAssignableFrom(value.getClass())) {
            this.writeTo(name, (ParameterValueArray)value, out);
        } else if (ParameterValueMap.class.isAssignableFrom(value.getClass())) {
            this.writeTo(name, (ParameterValueMap)value, out);
        }
    }

    private void writeTo(String name, ParameterValueArray array, OutputStream out) throws IOException {
        String childName = name + "[]";
        for (ParameterValue value : (List)array.getValue()) {
            this.writeTo(childName, value, out);
        }
    }

    private void writeTo(String name, StringValue stringValue, OutputStream out) throws IOException {
        StringBuilder builder = new StringBuilder();
        if (!this.firstParameter) {
            builder.append('&');
        } else {
            this.firstParameter = false;
        }
        String value = this.encode((String)stringValue.getValue());
        String parameterString = builder.append(name).append('=').append(value).toString();
        out.write(parameterString.getBytes());
        LOGGER.trace(out.toString());
    }

    private String encode(String value) throws UnsupportedEncodingException {
        if (UrlUtils.isUrl(value)) {
            return value;
        }
        return URLEncoder.encode(value, UTF8);
    }
}

