/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.hadoop;

import io.fabric8.api.Container;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileBuilder;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Version;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="hadoop", name="create", description="Create an Hadoop cluster")
public class CreateAction
extends AbstractAction {
    @Option(name="--name")
    private String name = "default";
    @Option(name="--name-node")
    private String nameNode = "namenode";
    @Option(name="--secondary-name-node")
    private String secondaryNameNode;
    @Option(name="--data-nodes")
    private List<String> dataNodes = Collections.singletonList("datanode");
    @Option(name="--job-tracker")
    private String jobTracker;
    @Option(name="--task-trackers")
    private List<String> taskTrackers = Collections.emptyList();
    @Option(name="--create-children")
    private boolean createChildren = false;
    @Option(name="--force")
    private boolean force = false;
    private final ProfileService profileService;
    private final FabricService fabricService;

    CreateAction(FabricService fabricService) {
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        Container cont;
        String versionId;
        Container[] containers = this.fabricService.getContainers();
        if (this.nameNode == null || this.dataNodes.isEmpty()) {
            throw new IllegalArgumentException("The name node and at least one data node must be specified");
        }
        if (!this.taskTrackers.isEmpty() && this.jobTracker == null) {
            throw new IllegalArgumentException("Can not specify task trackers if no job tracker is specified");
        }
        if (this.taskTrackers.isEmpty() && this.jobTracker != null) {
            throw new IllegalArgumentException("At least one task tracker node must be specified");
        }
        if (!this.createChildren) {
            if (this.findContainer(containers, this.nameNode) == null) {
                throw new IllegalStateException("Container " + this.nameNode + " does not exists");
            }
            if (this.secondaryNameNode != null && this.findContainer(containers, this.secondaryNameNode) == null) {
                throw new IllegalStateException("Container " + this.secondaryNameNode + " does not exists");
            }
            for (String n : this.dataNodes) {
                if (this.findContainer(containers, n) != null) continue;
                throw new IllegalStateException("Container " + n + " does not exists");
            }
            if (this.jobTracker != null && this.findContainer(containers, this.jobTracker) == null) {
                throw new IllegalStateException("Container " + this.jobTracker + " does not exists");
            }
            for (String n : this.taskTrackers) {
                if (this.findContainer(containers, n) != null) continue;
                throw new IllegalStateException("Container " + n + " does not exists");
            }
        }
        ProfileService profileService = (ProfileService)this.fabricService.adapt(ProfileService.class);
        for (String p : Arrays.asList("hadoop-" + this.name, "hadoop-" + this.name + "-namenode", "hadoop-" + this.name + "-secondary-namenode", "hadoop-" + this.name + "-datanode", "hadoop-" + this.name + "-job-tracker", "hadoop-" + this.name + "-task-tracker", "insight-hdfs-" + this.name)) {
            Profile profile = null;
            try {
                profile = this.fabricService.getRequiredDefaultVersion().getProfile(p);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (profile == null) continue;
            versionId = profile.getVersion();
            String profileId = profile.getId();
            if (this.force) {
                profileService.deleteProfile(this.fabricService, versionId, profileId, this.force);
                continue;
            }
            throw new IllegalStateException("Profile " + profileId + " already exists. Use --force to recreate the profiles.");
        }
        Version version = this.fabricService.getRequiredDefaultVersion();
        Profile hadoop = version.getRequiredProfile("hadoop");
        versionId = version.getId();
        ProfileBuilder builder = ProfileBuilder.Factory.create((String)versionId, (String)("hadoop-" + this.name));
        builder.addParent(hadoop);
        HashMap configs = new HashMap();
        configs.put("io.fabric8.hadoop", new HashMap());
        ((Map)configs.get("io.fabric8.hadoop")).put("fs.default.name", "hdfs://${zk:" + this.nameNode + "/ip}:9000");
        ((Map)configs.get("io.fabric8.hadoop")).put("dfs.http.address", "hdfs://${zk:" + this.nameNode + "/ip}:9002");
        Profile cluster = profileService.createProfile(builder.setConfigurations(configs).getProfile());
        builder = ProfileBuilder.Factory.create((String)versionId, (String)("hadoop-" + this.name + "-namenode"));
        builder.addParent(cluster);
        configs = new HashMap();
        configs.put("io.fabric8.hadoop", new HashMap());
        ((Map)configs.get("io.fabric8.hadoop")).put("nameNode", "true");
        Profile nameNodeProfile = profileService.createProfile(builder.setConfigurations(configs).getProfile());
        builder = ProfileBuilder.Factory.create((String)versionId, (String)("hadoop-" + this.name + "-secondary-namenode"));
        builder.addParent(cluster);
        configs = new HashMap();
        configs.put("io.fabric8.hadoop", new HashMap());
        ((Map)configs.get("io.fabric8.hadoop")).put("secondaryNameNode", "true");
        Profile secondaryNameNodeProfile = profileService.createProfile(builder.setConfigurations(configs).getProfile());
        builder = ProfileBuilder.Factory.create((String)versionId, (String)("hadoop-" + this.name + "-datanode"));
        builder.addParent(cluster);
        configs = new HashMap();
        configs.put("io.fabric8.hadoop", new HashMap());
        ((Map)configs.get("io.fabric8.hadoop")).put("dataNode", "true");
        Profile dataNodeProfile = profileService.createProfile(builder.setConfigurations(configs).getProfile());
        builder = ProfileBuilder.Factory.create((String)versionId, (String)("hadoop-" + this.name + "-job-tracker"));
        builder.addParent(cluster);
        configs = new HashMap();
        configs.put("io.fabric8.hadoop", new HashMap());
        ((Map)configs.get("io.fabric8.hadoop")).put("jobTracker", "true");
        Profile jobTrackerProfile = profileService.createProfile(builder.setConfigurations(configs).getProfile());
        builder = ProfileBuilder.Factory.create((String)versionId, (String)("hadoop-" + this.name + "-task-tracker"));
        builder.addParent(cluster);
        configs = new HashMap();
        configs.put("io.fabric8.hadoop", new HashMap());
        ((Map)configs.get("io.fabric8.hadoop")).put("taskTracker", "true");
        Profile taskTrackerProfile = profileService.createProfile(builder.setConfigurations(configs).getProfile());
        builder = ProfileBuilder.Factory.create((String)versionId, (String)("insight-hdfs-" + this.name));
        builder.addParent(version.getRequiredProfile("insight-hdfs"));
        configs = new HashMap();
        configs.put("io.fabric8.insight.elasticsearch-default", new HashMap());
        ((Map)configs.get("io.fabric8.insight.elasticsearch-default")).put("gateway.hdfs.uri", "hdfs://${zk:" + this.nameNode + "/ip}:9000");
        Profile insightProfile = profileService.createProfile(builder.setConfigurations(configs).getProfile());
        Container nameNodeContainer = this.findContainer(containers, this.nameNode);
        if (nameNodeContainer == null && this.createChildren) {
            nameNodeContainer = this.createChild(this.nameNode);
        }
        this.addProfile(nameNodeContainer, nameNodeProfile);
        if (this.secondaryNameNode != null) {
            Container secondaryNameNodeContainer = this.findContainer(containers, this.secondaryNameNode);
            if (secondaryNameNodeContainer == null && this.createChildren) {
                secondaryNameNodeContainer = this.createChild(this.secondaryNameNode);
            }
            this.addProfile(secondaryNameNodeContainer, secondaryNameNodeProfile);
        }
        for (String n : this.dataNodes) {
            cont = this.findContainer(containers, n);
            if (cont == null) {
                cont = this.createChild(n);
            }
            this.addProfile(cont, dataNodeProfile);
        }
        if (this.jobTracker != null) {
            Container jobTrackerContainer = this.findContainer(containers, this.jobTracker);
            if (jobTrackerContainer == null && this.createChildren) {
                jobTrackerContainer = this.createChild(this.jobTracker);
            }
            this.addProfile(jobTrackerContainer, jobTrackerProfile);
        }
        for (String n : this.taskTrackers) {
            cont = this.findContainer(containers, n);
            if (cont == null) {
                cont = this.createChild(n);
            }
            this.addProfile(cont, taskTrackerProfile);
        }
        return null;
    }

    private Container createChild(String name) throws URISyntaxException {
        CreateChildContainerOptions options = ((CreateChildContainerOptions.Builder)((CreateChildContainerOptions.Builder)CreateChildContainerOptions.builder().name(name)).parent(this.fabricService.getCurrentContainer().getId())).build();
        CreateContainerMetadata[] metadatas = this.fabricService.createContainers((CreateContainerOptions)options);
        Container container = metadatas[0].getContainer();
        return container;
    }

    private void addProfile(Container container, Profile profile) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (Profile p : container.getProfiles()) {
            if (this.isAncestor(p, profile)) continue;
            profiles.add(p);
        }
        profiles.add(profile);
        container.setProfiles(profiles.toArray(new Profile[profiles.size()]));
    }

    private boolean isAncestor(Profile parent, Profile child) {
        if (child.getId().equals(parent.getId())) {
            return true;
        }
        for (Profile p : child.getParents()) {
            if (!this.isAncestor(parent, p)) continue;
            return true;
        }
        return false;
    }

    private Container findContainer(Container[] containers, String name) {
        for (Container cont : containers) {
            if (!name.equals(cont.getId())) continue;
            return cont;
        }
        return null;
    }
}

