/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.common.util.Strings;
import io.fabric8.utils.FabricValidations;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="container-info", scope="fabric", description="Displays information about the containers")
public class ContainerInfoAction
extends AbstractAction {
    static final String FORMAT = "%-30s %s";
    @Argument(index=0, name="container", description="The name of the container container.", required=false, multiValued=false)
    private String containerName;
    private final FabricService fabricService;
    private final DataStore dataStore;
    private final RuntimeProperties runtimeProperties;

    ContainerInfoAction(FabricService fabricService, RuntimeProperties runtimeProperties) {
        this.fabricService = fabricService;
        this.dataStore = (DataStore)fabricService.adapt(DataStore.class);
        this.runtimeProperties = runtimeProperties;
    }

    protected Object doExecute() throws Exception {
        this.containerName = Strings.isNotBlank((String)this.containerName) ? this.containerName : this.runtimeProperties.getRuntimeIdentity();
        FabricValidations.validateContainerName(this.containerName);
        if (!this.containerExists(this.containerName)) {
            System.out.println("Container " + this.containerName + " does not exists!");
            return null;
        }
        Container container = this.fabricService.getContainer(this.containerName);
        System.out.println(String.format(FORMAT, "Name:", container.getId()));
        System.out.println(String.format(FORMAT, "Version:", container.getVersion()));
        System.out.println(String.format(FORMAT, "Connected:", container.isAlive()));
        System.out.println(String.format(FORMAT, "Type:", Strings.emptyIfNull((String)container.getType())));
        Long processId = container.getProcessId();
        System.out.println(String.format(FORMAT, "Process ID:", processId != null ? processId.toString() : ""));
        if (Strings.isNotBlank((String)container.getLocation())) {
            System.out.println(String.format(FORMAT, "Location:", Strings.emptyIfNull((String)container.getLocation())));
        }
        System.out.println(String.format(FORMAT, "Resolver:", Strings.emptyIfNull((String)container.getResolver())));
        System.out.println(String.format(FORMAT, "Network Address:", Strings.emptyIfNull((String)container.getIp())));
        System.out.println(String.format(FORMAT, "Local Network Address:", Strings.emptyIfNull((String)container.getLocalIp())));
        System.out.println(String.format(FORMAT, "Public Network Address:", Strings.emptyIfNull((String)container.getPublicIp())));
        System.out.println(String.format(FORMAT, "Local Hostname:", Strings.emptyIfNull((String)container.getLocalHostname())));
        System.out.println(String.format(FORMAT, "Public Hostname:", Strings.emptyIfNull((String)container.getPublicHostname())));
        System.out.println(String.format(FORMAT, "SSH Url:", Strings.emptyIfNull((String)container.getSshUrl())));
        System.out.println(String.format(FORMAT, "JMX Url:", Strings.emptyIfNull((String)container.getJmxUrl())));
        System.out.println(String.format(FORMAT, "Http Url:", Strings.emptyIfNull((String)container.getHttpUrl())));
        System.out.println(String.format(FORMAT, "Jolokia Url:", Strings.emptyIfNull((String)container.getJolokiaUrl())));
        String debugPort = container.getDebugPort();
        if (Strings.isNotBlank((String)debugPort)) {
            System.out.println(String.format(FORMAT, "Debug Port:", debugPort));
        }
        Profile[] profiles = container.getProfiles();
        for (int i = 0; i < profiles.length; ++i) {
            String id = profiles[i].getId();
            if (i == 0) {
                System.out.println(String.format(FORMAT, "Profiles:", id));
                continue;
            }
            System.out.println(String.format(FORMAT, "", id));
        }
        String blueprintStatus = this.dataStore.getContainerAttribute(this.containerName, DataStore.ContainerAttribute.BlueprintStatus, "", false, false);
        String springStatus = this.dataStore.getContainerAttribute(this.containerName, DataStore.ContainerAttribute.SpringStatus, "", false, false);
        if (!blueprintStatus.isEmpty()) {
            System.out.println(String.format(FORMAT, "Blueprint Status:", blueprintStatus.toLowerCase()));
        }
        if (!springStatus.isEmpty()) {
            System.out.println(String.format(FORMAT, "Spring Status:", springStatus.toLowerCase()));
        }
        System.out.println(String.format(FORMAT, "Provision Status:", container.getProvisionStatus()));
        if (container.getProvisionException() != null) {
            System.out.println(String.format(FORMAT, "Provision Error:", container.getProvisionException()));
        }
        return null;
    }

    private boolean containerExists(String containerName) {
        Container[] containers;
        for (Container c : containers = this.fabricService.getContainers()) {
            if (!containerName.equals(c.getId())) continue;
            return true;
        }
        return false;
    }
}

