/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.boot.commands.support.AbstractCommandComponent;
import io.fabric8.boot.commands.support.ParameterCompleter;
import io.fabric8.boot.commands.support.ProfileCompleter;
import io.fabric8.boot.commands.support.ResolverCompleter;
import io.fabric8.boot.commands.support.VersionCompleter;
import io.fabric8.commands.ContainerCreateChildAction;
import io.fabric8.commands.support.RootContainerCompleter;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.console.Completer;

@Component(immediate=true)
@Service(value={Function.class, AbstractCommand.class})
@Properties(value={@Property(name="osgi.command.scope", value={"fabric"}), @Property(name="osgi.command.function", value={"container-create-child"})})
public class ContainerCreateChild
extends AbstractCommandComponent {
    public static final String SCOPE_VALUE = "fabric";
    public static final String FUNCTION_VALUE = "container-create-child";
    public static final String DESCRIPTION = "Creates one or more child containers";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ZooKeeperClusterService.class)
    private final ValidatingReference<ZooKeeperClusterService> clusterService = new ValidatingReference();
    @Reference(referenceInterface=RootContainerCompleter.class, bind="bindRootContainerCompleter", unbind="unbindRootContainerCompleter")
    private RootContainerCompleter rootContainerCompleter;
    @Reference(referenceInterface=ProfileCompleter.class, bind="bindProfileCompleter", unbind="unbindProfileCompleter")
    private ProfileCompleter profileCompleter;
    @Reference(referenceInterface=ResolverCompleter.class, bind="bindResolverCompleter", unbind="unbindResolverCompleter")
    private ResolverCompleter resolverCompleter;
    @Reference(referenceInterface=VersionCompleter.class, bind="bindVersionCompleter", unbind="unbindVersionCompleter")
    private VersionCompleter versionCompleter;

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public Action createNewAction() {
        this.assertValid();
        return new ContainerCreateChildAction((FabricService)this.fabricService.get(), (ZooKeeperClusterService)this.clusterService.get());
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    void bindClusterService(ZooKeeperClusterService clusterService) {
        this.clusterService.bind((Object)clusterService);
    }

    void unbindClusterService(ZooKeeperClusterService clusterService) {
        this.clusterService.unbind((Object)clusterService);
    }

    void bindRootContainerCompleter(RootContainerCompleter completer) {
        this.bindCompleter((Completer)completer);
    }

    void unbindRootContainerCompleter(RootContainerCompleter completer) {
        this.unbindCompleter((Completer)completer);
    }

    void bindProfileCompleter(ProfileCompleter completer) {
        this.bindOptionalCompleter((ParameterCompleter)completer);
    }

    void unbindProfileCompleter(ProfileCompleter completer) {
        this.unbindOptionalCompleter((ParameterCompleter)completer);
    }

    void bindResolverCompleter(ResolverCompleter completer) {
        this.bindOptionalCompleter((ParameterCompleter)completer);
    }

    void unbindResolverCompleter(ResolverCompleter completer) {
        this.unbindOptionalCompleter((ParameterCompleter)completer);
    }

    void bindVersionCompleter(VersionCompleter completer) {
        this.bindOptionalCompleter((ParameterCompleter)completer);
    }

    void unbindVersionCompleter(VersionCompleter completer) {
        this.unbindOptionalCompleter((ParameterCompleter)completer);
    }
}

