/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftUnknonwSSHKeyTypeException;
import com.openshift.client.SSHKeyType;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.UserResource;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.httpclient.request.StringParameter;
import com.openshift.internal.client.response.KeyResourceDTO;
import com.openshift.internal.client.utils.Assert;

public class SSHKeyResource
extends AbstractOpenShiftResource
implements IOpenShiftSSHKey {
    private String name;
    private SSHKeyType type;
    private String publicKey;
    private UserResource user;

    protected SSHKeyResource(KeyResourceDTO dto, UserResource user) throws OpenShiftUnknonwSSHKeyTypeException {
        super(user.getService(), dto.getLinks(), dto.getMessages());
        this.name = dto.getName();
        this.type = SSHKeyType.getByTypeId(dto.getType());
        this.publicKey = dto.getContent();
        this.user = user;
    }

    @Override
    public void setKeyType(SSHKeyType type, String publicKey) throws OpenShiftException {
        Assert.notNull(type);
        Assert.notNull(publicKey);
        KeyResourceDTO dto = new UpdateKeyRequest().execute(type, publicKey);
        this.update(dto);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SSHKeyType getKeyType() {
        return this.type;
    }

    @Override
    public void setPublicKey(String publicKey) throws OpenShiftException {
        Assert.notNull(publicKey);
        KeyResourceDTO dto = new UpdateKeyRequest().execute(this.getKeyType(), publicKey);
        this.update(dto);
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public void refresh() throws OpenShiftException {
    }

    @Override
    public void destroy() throws OpenShiftException {
        new DeleteKeyRequest().execute();
        this.user.removeSSHKey(this);
        this.name = null;
        this.type = null;
        this.publicKey = null;
    }

    protected void update(KeyResourceDTO dto) throws OpenShiftUnknonwSSHKeyTypeException {
        if (dto == null) {
            return;
        }
        this.type = SSHKeyType.getByTypeId(dto.getType());
        this.publicKey = dto.getContent();
    }

    public String toString() {
        return "SSHKeyResource [name=" + this.name + ", type=" + (Object)((Object)this.type) + ", publicKey=" + this.publicKey + "]";
    }

    private class DeleteKeyRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private DeleteKeyRequest() {
            super("DELETE");
        }

        protected void execute() throws OpenShiftException {
            super.execute(new Parameter[0]);
        }
    }

    private class UpdateKeyRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        private UpdateKeyRequest() {
            super("UPDATE");
        }

        protected KeyResourceDTO execute(SSHKeyType type, String publicKey) throws OpenShiftException {
            return (KeyResourceDTO)this.execute(new StringParameter("content", publicKey), new StringParameter("type", type.getTypeId()));
        }
    }
}

