/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IApplication;
import com.openshift.client.IEnvironmentVariable;
import com.openshift.client.Messages;
import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.httpclient.request.Parameter;
import com.openshift.internal.client.response.EnvironmentVariableResourceDTO;
import com.openshift.internal.client.response.Link;
import java.util.Map;

public class EnvironmentVariableResource
extends AbstractOpenShiftResource
implements IEnvironmentVariable {
    private static final String LINK_GET = "GET";
    private static final String LINK_UPDATE = "UPDATE";
    private static final String LINK_DELETE = "DELETE";
    private String name;
    private String value;
    private ApplicationResource application;

    protected EnvironmentVariableResource(EnvironmentVariableResourceDTO dto, ApplicationResource application) {
        this(dto.getName(), dto.getValue(), dto.getMessages(), dto.getLinks(), application);
    }

    protected EnvironmentVariableResource(String name, String value, Messages messages, Map<String, Link> links, ApplicationResource application) {
        super(application.getService(), links, messages);
        this.name = name;
        this.value = value;
        this.application = application;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void update(String newValue) throws OpenShiftException {
        if (newValue == null) {
            throw new OpenShiftException("Value for environment variable \"{0}\" not given.", this.name);
        }
        EnvironmentVariableResourceDTO environmentVariableResourceDTO = new UpdateEnvironmentVariableRequest().execute(newValue);
        this.updateEnvironmentVariable(environmentVariableResourceDTO);
        this.application.updateEnvironmentVariables();
    }

    private void updateEnvironmentVariable(EnvironmentVariableResourceDTO dto) {
        this.name = dto.getName();
        this.value = dto.getValue();
        this.getLinks().clear();
        this.getLinks().putAll(dto.getLinks());
    }

    @Override
    public void destroy() throws OpenShiftException {
        new DeleteEnvironmentVariableRequest().execute(new Parameter[0]);
    }

    @Override
    public void refresh() throws OpenShiftException {
        EnvironmentVariableResourceDTO environmentVariableResourceDTO = (EnvironmentVariableResourceDTO)new GetEnvironmentVariableRequest().execute(new Parameter[0]);
        this.updateEnvironmentVariable(environmentVariableResourceDTO);
    }

    @Override
    public IApplication getApplication() {
        return this.application;
    }

    public String toString() {
        return new String("Name:" + this.name + ",Value:" + this.value);
    }

    private class DeleteEnvironmentVariableRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected DeleteEnvironmentVariableRequest() {
            super(EnvironmentVariableResource.LINK_DELETE);
        }
    }

    private class GetEnvironmentVariableRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected GetEnvironmentVariableRequest() {
            super(EnvironmentVariableResource.LINK_GET);
        }
    }

    private class UpdateEnvironmentVariableRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected UpdateEnvironmentVariableRequest() {
            super(EnvironmentVariableResource.LINK_UPDATE);
        }

        protected EnvironmentVariableResourceDTO execute(String value) throws OpenShiftException {
            AbstractOpenShiftResource.Parameters parameters = new AbstractOpenShiftResource.Parameters().add("value", value);
            return (EnvironmentVariableResourceDTO)super.execute(parameters.toArray());
        }
    }
}

