/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.commands;

import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IUser;
import com.openshift.client.cartridge.StandaloneCartridge;
import io.fabric8.openshift.commands.OpenshiftCommandSupport;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;

@Command(name="application-create", scope="openshift", description="Creates an application")
public class ApplicationCreateAction
extends OpenshiftCommandSupport {
    static final String FORMAT = "%-30s %s";
    @Option(name="--domain", required=false, description="Create applications on that domain.")
    String domainId;
    @Argument(index=0, name="application", required=true, description="The target application.")
    String applicationName;
    @Argument(index=1, name="cartridge", required=true, multiValued=false, description="The cartridge to use.")
    String cartridge;

    protected Object doExecute() throws Exception {
        IDomain domain;
        IOpenShiftConnection connection = this.getOrCreateConnection();
        IUser user = connection.getUser();
        IDomain iDomain = domain = this.domainId != null ? user.getDomain(this.domainId) : user.getDefaultDomain();
        if (this.domainId != null && domain == null) {
            domain = user.createDomain(this.domainId);
        }
        IApplication application = domain.createApplication(this.applicationName, new StandaloneCartridge(this.cartridge));
        System.out.println(application.getCreationLog());
        return null;
    }
}

