/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.curator.framework.CuratorFramework;
import org.jledit.ContentManager;

public class ZookeeperContentManager
implements ContentManager {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final CuratorFramework curator;

    public ZookeeperContentManager(CuratorFramework curator) {
        this.curator = curator;
    }

    public String load(String location) throws IOException {
        try {
            String data = ZooKeeperUtils.getStringData((CuratorFramework)this.curator, (String)location);
            return data != null ? data : "";
        }
        catch (Exception e) {
            throw new IOException("Failed to read data from zookeeper.", e);
        }
    }

    public boolean save(String content, String location) {
        try {
            ZooKeeperUtils.setData((CuratorFramework)this.curator, (String)location, (String)content);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean save(String content, Charset charset, String location) {
        return this.save(content, location);
    }

    public Charset detectCharset(String location) {
        return UTF_8;
    }
}

