/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.utils.FabricValidations;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-copy", scope="fabric", description="Copies the specified version of the source profile (where the version defaults to the current default version)")
public class ProfileCopyAction
extends AbstractAction {
    @Option(name="--version", description="The profile version to copy. Defaults to the current default version.")
    private String versionParam;
    @Option(name="-f", aliases={"--force"}, description="Flag to allow overwriting the target profile (if exists).")
    private boolean force;
    @Argument(index=0, required=true, name="source profile", description="Name of the source profile.")
    @CompleterValues(index=0)
    private String source;
    @Argument(index=1, required=true, name="target profile", description="Name of the target profile.")
    @CompleterValues(index=1)
    private String target;
    private final ProfileService profileService;
    private final FabricService fabricService;

    ProfileCopyAction(FabricService fabricService) {
        this.profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        this.fabricService = fabricService;
    }

    protected Object doExecute() throws Exception {
        FabricValidations.validateProfileName(this.source);
        FabricValidations.validateProfileName(this.target);
        Version version = this.versionParam != null ? this.profileService.getRequiredVersion(this.versionParam) : this.fabricService.getRequiredDefaultVersion();
        String versionId = version.getId();
        if (!version.hasProfile(this.source)) {
            System.out.println("Source profile " + this.source + " not found.");
            return null;
        }
        if (version.hasProfile(this.target) && !this.force) {
            System.out.println("Target profile " + this.target + " already exists. Use --force if you want to overwrite.");
            return null;
        }
        Profiles.copyProfile((FabricService)this.fabricService, (String)versionId, (String)this.source, (String)this.target, (boolean)this.force);
        return null;
    }
}

