/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="listVersions", description="Lists all versions of a feature available from the currently available repositories.")
public class ListFeatureVersionsCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="feature", description="Name of feature.", required=true, multiValued=false)
    String feature;
    private static final String VERSION = "Version";
    private static final String REPOSITORY = "Repository";
    private static final String REPOSITORY_URL = "Repository URL";

    protected void doExecute(FeaturesService admin) throws Exception {
        int i;
        ArrayList<VersionInRepository> versionsInRepositories = new ArrayList<VersionInRepository>();
        for (Repository r : Arrays.asList(admin.listRepositories())) {
            for (Feature f : r.getFeatures()) {
                if (!f.getName().equals(this.feature)) continue;
                VersionInRepository versionInRepository = new VersionInRepository();
                versionInRepository.repository = r;
                versionInRepository.version = f.getVersion();
                versionsInRepositories.add(versionInRepository);
            }
        }
        if (versionsInRepositories.size() == 0) {
            System.out.println("No versions available for features '" + this.feature + "'");
            return;
        }
        int maxVersionSize = VERSION.length();
        for (VersionInRepository vir : versionsInRepositories) {
            maxVersionSize = Math.max(maxVersionSize, vir.version.length());
        }
        int maxRepositorySize = REPOSITORY.length();
        for (VersionInRepository vir : versionsInRepositories) {
            maxRepositorySize = Math.max(maxRepositorySize, vir.repository.getName().length());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION).append("   ");
        for (i = VERSION.length(); i < maxVersionSize; ++i) {
            sb.append(" ");
        }
        sb.append(REPOSITORY).append(" ");
        for (i = REPOSITORY.length(); i < maxRepositorySize; ++i) {
            sb.append(" ");
        }
        sb.append(" ");
        sb.append(REPOSITORY_URL);
        System.out.println(sb.toString());
        for (VersionInRepository vir : versionsInRepositories) {
            int i2;
            sb.setLength(0);
            sb.append("[");
            String str = vir.version;
            sb.append(str);
            for (i2 = str.length(); i2 < maxVersionSize; ++i2) {
                sb.append(" ");
            }
            sb.append("] ");
            str = vir.repository.getName();
            sb.append(str);
            for (i2 = str.length(); i2 < maxRepositorySize; ++i2) {
                sb.append(" ");
            }
            sb.append(" ");
            sb.append(vir.repository.getURI());
            System.out.println(sb.toString());
        }
    }

    private class VersionInRepository {
        public String version;
        public Repository repository;

        private VersionInRepository() {
        }
    }
}

