/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.commands.AbstractContainerLifecycleAction;
import io.fabric8.utils.FabricValidations;
import java.util.Collection;
import org.apache.felix.gogo.commands.Command;

@Command(name="container-stop", scope="fabric", description="Shut down an existing container", detailedDescription="classpath:containerStop.txt")
public final class ContainerStopAction
extends AbstractContainerLifecycleAction {
    ContainerStopAction(FabricService fabricService) {
        super(fabricService);
    }

    protected Object doExecute() throws Exception {
        Collection<String> expandedNames = super.expandGlobNames(this.containers);
        for (String containerName : expandedNames) {
            FabricValidations.validateContainerName(containerName);
            if (!this.force && FabricCommand.isPartOfEnsemble((FabricService)this.fabricService, (String)containerName)) {
                System.out.println("Container is part of the ensemble. If you still want to stop it, please use --force option.");
                return null;
            }
            Container found = FabricCommand.getContainer((FabricService)this.fabricService, (String)containerName);
            this.applyUpdatedCredentials(found);
            if (found.isAlive()) {
                found.stop(this.force);
                this.session.getConsole().println("Container '" + found.getId() + "' stopped successfully.");
                continue;
            }
            System.err.println("Container '" + found.getId() + "' already stopped.");
        }
        return null;
    }
}

