/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.commands.AbstractContainerLifecycleAction;
import io.fabric8.utils.FabricValidations;
import java.util.Collection;
import org.apache.felix.gogo.commands.Command;

@Command(name="container-start", scope="fabric", description="Start the specified container", detailedDescription="classpath:containerStart.txt")
public final class ContainerStartAction
extends AbstractContainerLifecycleAction {
    ContainerStartAction(FabricService fabricService) {
        super(fabricService);
    }

    protected Object doExecute() throws Exception {
        Collection<String> expandedNames = super.expandGlobNames(this.containers);
        for (String containerName : expandedNames) {
            FabricValidations.validateContainerName(containerName);
            Container found = FabricCommand.getContainer((FabricService)this.fabricService, (String)containerName);
            this.applyUpdatedCredentials(found);
            if (this.force || !found.isAlive()) {
                found.start(this.force);
                continue;
            }
            System.err.println("Container " + containerName + " is already started");
        }
        return null;
    }
}

